/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.expressions.ExpressionEvaluator;
import generic.expressions.ExpressionException;
import generic.expressions.ExpressionValue;
import generic.expressions.LongExpressionValue;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AddressExpressionValue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;

public class AddressEvaluator
extends ExpressionEvaluator {
    private Reference<Program> programReference;
    private AddressFactory addressFactory;
    private AddressSpace preferredSpace;

    public static Address evaluate(Program p, String inputExpression) {
        return AddressEvaluator.evaluate(p, null, inputExpression);
    }

    public static Address evaluate(Program p, Address baseAddr, String inputExpression) {
        AddressEvaluator evaluator = new AddressEvaluator(p, true);
        try {
            return evaluator.parseAsRelativeAddress(inputExpression, baseAddr);
        }
        catch (ExpressionException e) {
            return null;
        }
    }

    public AddressEvaluator(Program program, boolean assumeHex) {
        this(program, null, assumeHex);
    }

    public AddressEvaluator(AddressFactory factory, boolean assumeHex) {
        this(factory, null, assumeHex);
    }

    public AddressEvaluator(Program program, AddressSpace defaultSpace, boolean assumeHex) {
        this(program.getAddressFactory(), defaultSpace, assumeHex);
        this.programReference = new WeakReference<Program>(program);
    }

    private AddressEvaluator(AddressFactory factory, AddressSpace defaultSpace, boolean assumeHex) {
        super(assumeHex);
        this.addressFactory = factory;
        this.preferredSpace = defaultSpace;
    }

    public Address parseAsAddress(String input) throws ExpressionException {
        return this.parseAsRelativeAddress(input, null);
    }

    public Address parseAsRelativeAddress(String input, Address baseAddress) throws ExpressionException {
        ExpressionValue expressionValue;
        ExpressionValue expressionValue2 = expressionValue = baseAddress == null ? this.parse(input) : this.parse(input, new AddressExpressionValue(baseAddress));
        if (expressionValue instanceof AddressExpressionValue) {
            AddressExpressionValue addressValue = (AddressExpressionValue)expressionValue;
            return this.validateAddressSpace(addressValue.getAddress());
        }
        if (expressionValue instanceof LongExpressionValue) {
            LongExpressionValue longValue = (LongExpressionValue)expressionValue;
            long offset = longValue.getLongValue();
            AddressSpace space = this.getAddressSpace();
            try {
                return space.getAddressInThisSpaceOnly(offset * (long)space.getAddressableUnitSize());
            }
            catch (AddressOutOfBoundsException e) {
                throw new ExpressionException(e.getMessage());
            }
        }
        throw new ExpressionException("Expression did not evalute to a long! Got a " + String.valueOf(expressionValue.getClass()) + " instead.");
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public void setPreferredAddressSpace(AddressSpace space) {
        this.preferredSpace = space;
    }

    private Address validateAddressSpace(Address address) throws ExpressionException {
        if (this.preferredSpace == null) {
            return address;
        }
        AddressSpace space = address.getAddressSpace();
        if (space.equals(this.preferredSpace)) {
            return address;
        }
        if (this.isOverlayRelated(space, this.preferredSpace)) {
            return this.preferredSpace.getAddress(address.getOffset());
        }
        throw new ExpressionException("Selected address space is not compatible with expression!");
    }

    private boolean isOverlayRelated(AddressSpace space1, AddressSpace space2) {
        AddressSpace base1 = this.getBaseSpace(space1);
        AddressSpace base2 = this.getBaseSpace(space2);
        return base1.equals(base2);
    }

    private AddressSpace getBaseSpace(AddressSpace space) {
        if (space instanceof OverlayAddressSpace) {
            OverlayAddressSpace overlaySpace = (OverlayAddressSpace)space;
            return overlaySpace.getOverlayedSpace();
        }
        return space;
    }

    private AddressSpace getAddressSpace() {
        if (this.preferredSpace != null) {
            return this.preferredSpace;
        }
        return this.addressFactory.getDefaultAddressSpace();
    }

    protected ExpressionValue evaluateSymbol(String input) {
        Address address = this.addressFactory.getAddress(input);
        if (address != null) {
            return new AddressExpressionValue(address);
        }
        Program program = this.getProgram();
        if (program != null) {
            return this.getAddressForProgram(program, input);
        }
        return null;
    }

    private ExpressionValue getAddressForProgram(Program program, String input) {
        Address address = this.getAddressForSymbol(program, input);
        if (address == null) {
            address = this.getAddressFromMemoryMap(program, input);
        }
        return address == null ? null : new AddressExpressionValue(address);
    }

    private Address getAddressFromMemoryMap(Program program, String input) {
        Memory memory = program.getMemory();
        MemoryBlock block = memory.getBlock(input);
        if (block != null) {
            return block.getStart();
        }
        return null;
    }

    private Address getAddressForSymbol(Program program, String input) {
        SymbolPath symbolPath = new SymbolPath(input);
        String symbolName = symbolPath.getName();
        SymbolPath parent = symbolPath.getParent();
        Namespace namespace = null;
        if (parent != null && (namespace = this.getParentNamespace(program, parent)) == null) {
            return null;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        List<Symbol> symbols = symbolTable.getLabelOrFunctionSymbols(symbolName, namespace);
        if (symbols.size() == 1) {
            return symbols.get(0).getAddress();
        }
        return null;
    }

    private Namespace getParentNamespace(Program program, SymbolPath path) {
        if (path == null) {
            return null;
        }
        List<Namespace> spaces = NamespaceUtils.getNamespaceByPath(program, null, path.getPath());
        if (spaces.size() == 1) {
            return spaces.get(0);
        }
        return null;
    }

    private Program getProgram() {
        if (this.programReference != null) {
            return this.programReference.get();
        }
        return null;
    }
}

