/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.lang3.ArrayUtils;

public interface MemBufferMixin
extends MemBuffer {
    public int getBytes(ByteBuffer var1, int var2);

    @Override
    default public byte getByte(int offset) throws MemoryAccessException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        if (this.getBytes(buffer, offset) < 1) {
            throw new MemoryAccessException("Couldn't get requested byte for " + this.getClass().getSimpleName());
        }
        return buffer.get(0);
    }

    @Override
    default public int getBytes(byte[] b, int offset) {
        return this.getBytes(ByteBuffer.wrap(b), offset);
    }

    default public ByteBuffer getBytesInFull(int offset, int len) throws MemoryAccessException {
        ByteBuffer buf = ByteBuffer.allocate(len);
        if (this.getBytes(buf, offset) != len) {
            throw new MemoryAccessException("Could not read enough bytes");
        }
        if (!this.isBigEndian()) {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buf;
    }

    @Override
    default public short getShort(int offset) throws MemoryAccessException {
        return this.getBytesInFull(offset, 2).getShort(0);
    }

    @Override
    default public int getInt(int offset) throws MemoryAccessException {
        return this.getBytesInFull(offset, 4).getInt(0);
    }

    @Override
    default public long getLong(int offset) throws MemoryAccessException {
        return this.getBytesInFull(offset, 8).getLong(0);
    }

    @Override
    default public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        byte[] buf = this.getBytesInFull(offset, size).array();
        if (!this.isBigEndian()) {
            ArrayUtils.reverse((byte[])buf);
        }
        if (signed) {
            return new BigInteger(buf);
        }
        return new BigInteger(1, buf);
    }
}

