/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import java.util.ArrayList;

public class ParamListStandardOut
extends ParamListStandard {
    @Override
    public void assignMap(PrototypePieces proto, DataTypeManager dtManager, ArrayList<ParameterPieces> res, boolean addAutoParams) {
        int[] status = new int[this.numgroup];
        for (int i = 0; i < this.numgroup; ++i) {
            status[i] = 0;
        }
        ParameterPieces store = new ParameterPieces();
        res.add(store);
        if (VoidDataType.isVoidDataType(proto.outtype)) {
            store.type = proto.outtype;
            return;
        }
        int responseCode = this.assignAddress(proto.outtype, proto, -1, dtManager, status, store);
        if (responseCode == 1) {
            responseCode = 3;
        }
        if (responseCode == 3 || responseCode == 4 || responseCode == 5) {
            int sz = this.spacebase == null ? -1 : this.spacebase.getPointerSize();
            Pointer pointerType = dtManager.getPointer(proto.outtype, sz);
            if (responseCode == 5) {
                store.type = VoidDataType.dataType;
            } else {
                this.assignAddressFallback(StorageClass.PTR, pointerType, false, status, store);
                store.type = pointerType;
            }
            store.isIndirect = true;
            if (addAutoParams) {
                ParameterPieces hiddenRet = new ParameterPieces();
                hiddenRet.type = pointerType;
                hiddenRet.hiddenReturnPtr = responseCode == 4 || responseCode == 5;
                res.add(hiddenRet);
            }
        }
    }
}

