/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.FunctionDefinitionDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Date;

class FunctionDefinitionDBAdapterV2
extends FunctionDefinitionDBAdapter {
    static final int VERSION = 2;
    static final int V2_FUNCTION_DEF_NAME_COL = 0;
    static final int V2_FUNCTION_DEF_COMMENT_COL = 1;
    static final int V2_FUNCTION_DEF_CAT_ID_COL = 2;
    static final int V2_FUNCTION_DEF_RETURN_ID_COL = 3;
    static final int V2_FUNCTION_DEF_FLAGS_COL = 4;
    static final int V2_FUNCTION_DEF_CALLCONV_COL = 5;
    static final int V2_FUNCTION_DEF_SOURCE_ARCHIVE_ID_COL = 6;
    static final int V2_FUNCTION_DEF_UNIVERSAL_DT_ID_COL = 7;
    static final int V2_FUNCTION_DEF_SOURCE_SYNC_TIME_COL = 8;
    static final int V2_FUNCTION_DEF_LAST_CHANGE_TIME_COL = 9;
    static final Schema V2_FUN_DEF_SCHEMA = new Schema(2, "Data Type ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, ByteField.INSTANCE, ByteField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Name", "Comment", "Category ID", "Return Type ID", "Flags", "Call Conv ID", "Source Archive ID", "Source Data Type ID", "Source Sync Time", "Last Change Time"});
    private Table table;

    public FunctionDefinitionDBAdapterV2(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + "Function Definitions";
        if (create) {
            this.table = handle.createTable(tableName, V2_FUN_DEF_SCHEMA, new int[]{2, 7});
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException(true);
            }
            int version = this.table.getSchema().getVersion();
            if (version != 2) {
                throw new VersionException(version < 2);
            }
        }
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    DBRecord createRecord(String name, String comments, long categoryID, long returnDtID, boolean hasNoReturn, boolean hasVarArgs, byte callingConventionID, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        byte flags = 0;
        if (hasVarArgs) {
            flags = (byte)(flags | 1);
        }
        if (hasNoReturn) {
            flags = (byte)(flags | 2);
        }
        long tableKey = this.table.getKey();
        long key = DataTypeManagerDB.createKey(6, tableKey);
        DBRecord record = V2_FUN_DEF_SCHEMA.createRecord(key);
        record.setString(0, name);
        record.setString(1, comments);
        record.setLongValue(2, categoryID);
        record.setLongValue(3, returnDtID);
        record.setByteValue(4, flags);
        record.setByteValue(5, callingConventionID);
        record.setLongValue(6, sourceArchiveID);
        record.setLongValue(7, sourceDataTypeID);
        record.setLongValue(8, lastChangeTime);
        record.setLongValue(9, lastChangeTime);
        this.table.putRecord(record);
        return record;
    }

    @Override
    DBRecord getRecord(long functionDefID) throws IOException {
        return this.table.getRecord(functionDefID);
    }

    @Override
    void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        if (setLastChangeTime) {
            record.setLongValue(9, new Date().getTime());
        }
        this.table.putRecord(record);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    boolean removeRecord(long functionDefID) throws IOException {
        return this.table.deleteRecord(functionDefID);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(this.table.getName());
    }

    @Override
    Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.table.findRecords((Field)new LongField(archiveID), 6);
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        Field[] keys = this.table.findRecords((Field)new LongField(datatypeID.getValue()), 7);
        for (int i = 0; i < keys.length; ++i) {
            DBRecord record = this.table.getRecord(keys[i]);
            if (record.getLongValue(6) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }
}

