/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.slghpatexpress.OperandResolve;
import ghidra.pcodeCPort.slghpatexpress.PatternEquation;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.sleigh.grammar.Location;

public class OperandEquation
extends PatternEquation {
    private int index;

    public OperandEquation(Location location, int ind) {
        super(location);
        this.index = ind;
    }

    @Override
    public void genPattern(VectorSTL<TokenPattern> ops) {
        this.setTokenPattern((TokenPattern)ops.get(this.index));
    }

    @Override
    public void operandOrder(Constructor ct, VectorSTL<OperandSymbol> order) {
        OperandSymbol sym = ct.getOperand(this.index);
        if (!sym.isMarked()) {
            order.push_back((Object)sym);
            sym.setMark();
        }
    }

    @Override
    public boolean resolveOperandLeft(OperandResolve state) {
        OperandSymbol sym = (OperandSymbol)state.operands.get(this.index);
        if (sym.isOffsetIrrelevant()) {
            sym.offsetbase = -1;
            sym.reloffset = 0;
            return true;
        }
        if (state.base == -2) {
            return false;
        }
        sym.offsetbase = state.base;
        sym.reloffset = state.offset;
        state.cur_rightmost = this.index;
        state.size = 0;
        return true;
    }
}

