/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.BufferFile;
import db.buffers.DataBuffer;
import db.buffers.IndexProvider;
import db.buffers.LocalBufferFile;
import ghidra.util.datastruct.IntArrayList;
import ghidra.util.datastruct.IntIntHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;

class VersionFile {
    private static final int MAGIC_NUMBER = 942486581;
    private static final String VERSION_PARM_PREFIX = "~VF.";
    private static final String MAGIC_NUMBER_PARM = "~VF.VersionFile";
    private static final String ORIGINAL_FILE_ID_HI_PARM = "~VF.OriginalIdHi";
    private static final String ORIGINAL_FILE_ID_LOW_PARM = "~VF.OriginalIdLow";
    private static final String TARGET_FILE_ID_HI_PARM = "~VF.TargetIdHi";
    private static final String TARGET_FILE_ID_LOW_PARM = "~VF.TargetIdLow";
    private static final String ORIGINAL_BUFFER_COUNT_PARM = "~VF.OrigBufCnt";
    private static final String MAP_BUFFER_INDEX_PARM = "~VF.MapIndex";
    private static final String FREE_LIST_BUFFER_INDEX_PARM = "~VF.FreeListIndex";
    private static final String FREE_LIST_SIZE_PARM = "~VF.FreeListSize";
    private static final String BAD_FREE_LIST = "Version file is corrupt - bad free list";
    private static final String BAD_BUFFER_MAP = "Version file is corrupt - bad buffer map";
    private static final int NEXT_BUFFER_INDEX_OFFSET = 0;
    private static final int FIRST_ENTRY_OFFSET = 4;
    private static final int BUFFER_MAP_ENTRY_SIZE = 8;
    private static final int FREE_LIST_ENTRY_SIZE = 4;
    private File file;
    private long lastModified;
    private boolean readOnly;
    private int bufferSize;
    private int originalBufCount;
    private int initialBufCount;
    private BufferFile versionFile;
    private long targetFileId;
    private long originalFileId;
    private IndexProvider vfIndexProvider;
    private int[] freeIndexes;
    private IntIntHashtable bufferIndexMap;
    private IntArrayList newMapIds;
    private DataBuffer lastMapBuffer;
    private int lastMapIndex;
    private int nextMapEntryOffset;

    VersionFile(LocalBufferFile originalBf, LocalBufferFile targetBf, File vfile) throws IOException {
        this.bufferSize = originalBf.getBufferSize();
        this.originalBufCount = originalBf.getIndexCount();
        this.initialBufCount = 0;
        this.file = vfile;
        this.readOnly = false;
        this.versionFile = new LocalBufferFile(vfile, this.bufferSize);
        this.vfIndexProvider = new IndexProvider();
        this.versionFile.setParameter(MAGIC_NUMBER_PARM, 942486581);
        this.originalFileId = originalBf.getFileId();
        this.versionFile.setParameter(ORIGINAL_FILE_ID_HI_PARM, (int)(this.originalFileId >> 32));
        this.versionFile.setParameter(ORIGINAL_FILE_ID_LOW_PARM, (int)(this.originalFileId & 0xFFFFFFFFL));
        this.targetFileId = targetBf.getFileId();
        this.versionFile.setParameter(ORIGINAL_BUFFER_COUNT_PARM, this.originalBufCount);
        this.bufferIndexMap = new IntIntHashtable();
        this.newMapIds = new IntArrayList();
        this.lastMapBuffer = new DataBuffer(this.bufferSize);
        this.lastMapIndex = this.vfIndexProvider.allocateIndex();
        this.lastMapBuffer.setId(this.lastMapIndex);
        this.lastMapBuffer.putInt(0, -1);
        this.lastMapBuffer.putInt(4, -1);
        this.nextMapEntryOffset = 4;
        this.versionFile.put(this.lastMapBuffer, this.lastMapIndex);
        this.versionFile.setParameter(MAP_BUFFER_INDEX_PARM, this.lastMapIndex);
        this.freeIndexes = originalBf.getFreeIndexes();
        Arrays.sort(this.freeIndexes);
        int freeListIndex = this.saveFreeIndexList();
        this.versionFile.setParameter(FREE_LIST_BUFFER_INDEX_PARM, freeListIndex);
        this.versionFile.setParameter(FREE_LIST_SIZE_PARM, this.freeIndexes.length);
        String[] parmNames = originalBf.getParameterNames();
        for (int i = 0; i < parmNames.length; ++i) {
            String name = parmNames[i];
            this.versionFile.setParameter(name, originalBf.getParameter(name));
        }
    }

    VersionFile(File vfile) throws IOException {
        this.file = vfile;
        this.readOnly = true;
        this.open();
    }

    VersionFile(BufferFile versionFile) throws IOException {
        if (!versionFile.isReadOnly()) {
            throw new AssertException("Read-only buffer file expected");
        }
        this.readOnly = true;
        this.versionFile = versionFile;
        this.bufferSize = versionFile.getBufferSize();
        this.initialBufCount = versionFile.getIndexCount();
    }

    void abort() throws IOException {
        if (this.versionFile == null) {
            return;
        }
        if (this.readOnly) {
            this.versionFile.close();
        } else if (this.initialBufCount > 0) {
            LocalBufferFile updateVerFile = (LocalBufferFile)this.versionFile;
            updateVerFile.truncate(this.initialBufCount);
            updateVerFile.close();
        } else {
            this.versionFile.delete();
        }
        this.versionFile = null;
        this.file = null;
    }

    void close() throws IOException {
        if (this.versionFile == null) {
            return;
        }
        if (!this.readOnly) {
            if (!this.versionFile.isReadOnly()) {
                this.updateBufferMap();
            }
            this.versionFile.setParameter(TARGET_FILE_ID_HI_PARM, (int)(this.targetFileId >> 32));
            this.versionFile.setParameter(TARGET_FILE_ID_LOW_PARM, (int)(this.targetFileId & 0xFFFFFFFFL));
        }
        this.versionFile.close();
        this.versionFile = null;
        if (!this.readOnly) {
            this.lastModified = this.file.lastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws IOException {
        if (this.versionFile != null) {
            return;
        }
        if (this.file == null) {
            throw new IOException("Version file has been aborted");
        }
        this.readOnly = true;
        this.versionFile = new LocalBufferFile(this.file, true);
        this.bufferSize = this.versionFile.getBufferSize();
        this.initialBufCount = this.versionFile.getIndexCount();
        boolean goodFile = false;
        try {
            if (this.versionFile.getParameter(MAGIC_NUMBER_PARM) == 942486581) {
                goodFile = true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (!goodFile) {
            throw new IOException("Corrupt version file");
        }
        long mod = this.file.lastModified();
        if (mod != this.lastModified) {
            boolean success = false;
            try {
                this.parseFile();
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.lastModified = mod;
        }
    }

    private void parseFile() throws IOException {
        try {
            this.originalBufCount = this.versionFile.getParameter(ORIGINAL_BUFFER_COUNT_PARM);
            this.originalFileId = (long)this.versionFile.getParameter(ORIGINAL_FILE_ID_HI_PARM) << 32 | (long)this.versionFile.getParameter(ORIGINAL_FILE_ID_LOW_PARM) & 0xFFFFFFFFL;
            this.targetFileId = (long)this.versionFile.getParameter(TARGET_FILE_ID_HI_PARM) << 32 | (long)this.versionFile.getParameter(TARGET_FILE_ID_LOW_PARM) & 0xFFFFFFFFL;
            this.readBufferMap(this.versionFile.getParameter(MAP_BUFFER_INDEX_PARM));
            this.readFreeIndexList(this.versionFile.getParameter(FREE_LIST_BUFFER_INDEX_PARM), this.versionFile.getParameter(FREE_LIST_SIZE_PARM));
        }
        catch (NoSuchElementException e) {
            throw new IOException("Corrupt version file");
        }
    }

    private void updateBufferMap() throws IOException {
        int maxOffset = this.bufferSize - 8;
        int cnt = this.newMapIds.size();
        for (int i = 0; i < cnt; ++i) {
            int verIndex;
            int origIndex = this.newMapIds.get(i);
            try {
                verIndex = this.bufferIndexMap.get(origIndex);
            }
            catch (NoValueException e) {
                throw new AssertException();
            }
            if (this.nextMapEntryOffset > maxOffset) {
                int nextIndex = this.vfIndexProvider.allocateIndex();
                this.lastMapBuffer.putInt(0, nextIndex);
                this.versionFile.put(this.lastMapBuffer, this.lastMapIndex);
                this.nextMapEntryOffset = 4;
                this.lastMapIndex = nextIndex;
                this.lastMapBuffer.setId(this.lastMapIndex);
            }
            this.nextMapEntryOffset = this.lastMapBuffer.putInt(this.nextMapEntryOffset, origIndex);
            this.nextMapEntryOffset = this.lastMapBuffer.putInt(this.nextMapEntryOffset, verIndex);
        }
        if (this.nextMapEntryOffset > maxOffset) {
            int nextIndex = this.vfIndexProvider.allocateIndex();
            this.lastMapBuffer.putInt(0, nextIndex);
            this.versionFile.put(this.lastMapBuffer, this.lastMapIndex);
            this.nextMapEntryOffset = 4;
            this.lastMapIndex = nextIndex;
            this.lastMapBuffer.setId(this.lastMapIndex);
        }
        this.lastMapBuffer.putInt(this.nextMapEntryOffset, -1);
        this.lastMapBuffer.putInt(0, -1);
        this.versionFile.put(this.lastMapBuffer, this.lastMapIndex);
        this.newMapIds.clear();
    }

    private void readBufferMap(int mapIndex) throws IOException {
        this.bufferIndexMap = new IntIntHashtable();
        int maxOffset = this.bufferSize - 8;
        this.lastMapIndex = mapIndex;
        this.lastMapBuffer = new DataBuffer();
        this.versionFile.get(this.lastMapBuffer, mapIndex);
        if (this.lastMapBuffer.isEmpty()) {
            throw new IOException(BAD_BUFFER_MAP);
        }
        this.nextMapEntryOffset = 4;
        while (true) {
            int origIndex;
            if (this.nextMapEntryOffset > maxOffset) {
                mapIndex = this.lastMapBuffer.getInt(0);
                this.versionFile.get(this.lastMapBuffer, mapIndex);
                this.lastMapIndex = mapIndex;
                if (this.lastMapBuffer.isEmpty()) {
                    throw new IOException(BAD_BUFFER_MAP);
                }
                this.nextMapEntryOffset = 4;
            }
            if ((origIndex = this.lastMapBuffer.getInt(this.nextMapEntryOffset)) < 0) {
                return;
            }
            this.nextMapEntryOffset += 4;
            int verIndex = this.lastMapBuffer.getInt(this.nextMapEntryOffset);
            this.nextMapEntryOffset += 4;
            this.bufferIndexMap.put(origIndex, verIndex);
        }
    }

    private int saveFreeIndexList() throws IOException {
        int freeListIndex;
        int thisIndex = freeListIndex = this.vfIndexProvider.allocateIndex();
        int nextIndex = -1;
        int maxOffset = this.bufferSize - 4;
        DataBuffer buf = new DataBuffer(this.bufferSize);
        buf.setId(thisIndex);
        int offset = 4;
        for (int i = 0; i < this.freeIndexes.length; ++i) {
            if (offset > maxOffset) {
                nextIndex = this.vfIndexProvider.allocateIndex();
                buf.putInt(0, nextIndex);
                this.versionFile.put(buf, thisIndex);
                offset = 4;
                thisIndex = nextIndex;
                buf.setId(thisIndex);
            }
            offset = buf.putInt(offset, this.freeIndexes[i]);
        }
        if (offset > maxOffset) {
            nextIndex = this.vfIndexProvider.allocateIndex();
            buf.putInt(0, nextIndex);
            this.versionFile.put(buf, thisIndex);
            offset = 4;
            thisIndex = nextIndex;
            buf.setId(thisIndex);
        }
        buf.putInt(offset, -1);
        buf.putInt(0, -1);
        this.versionFile.put(buf, thisIndex);
        return freeListIndex;
    }

    private void readFreeIndexList(int listIndex, int size) throws IOException {
        this.freeIndexes = new int[size];
        int maxOffset = this.bufferSize - 4;
        DataBuffer listBuffer = new DataBuffer();
        this.versionFile.get(listBuffer, listIndex);
        if (listBuffer.isEmpty()) {
            throw new IOException(BAD_FREE_LIST);
        }
        int offset = 4;
        int entryIx = 0;
        while (true) {
            int origIndex;
            if (offset > maxOffset) {
                listIndex = listBuffer.getInt(0);
                this.versionFile.get(listBuffer, listIndex);
                if (listBuffer.isEmpty()) {
                    throw new IOException(BAD_FREE_LIST);
                }
                offset = 4;
            }
            if ((origIndex = listBuffer.getInt(offset)) < 0) break;
            if (entryIx == size) {
                throw new IOException(BAD_FREE_LIST);
            }
            offset += 4;
            this.freeIndexes[entryIx++] = origIndex;
        }
        if (entryIx != size) {
            throw new IOException(BAD_FREE_LIST);
        }
        Arrays.sort(this.freeIndexes);
    }

    void setTargetFileId(long fileId) throws IOException {
        if (this.versionFile == null) {
            throw new IOException("Version file is closed");
        }
        if (this.readOnly) {
            throw new IOException("Version file is read-only");
        }
        this.targetFileId = fileId;
    }

    public boolean isPutOK(int index) {
        return index >= 0 && index < this.originalBufCount && !this.bufferIndexMap.contains(index) && !this.isFreeIndex(index);
    }

    private boolean isFreeIndex(int index) {
        int ix = Arrays.binarySearch(this.freeIndexes, index);
        return ix >= 0;
    }

    int[] getFreeIndexList() {
        return this.freeIndexes;
    }

    void putOldBuffer(DataBuffer buf, int index) throws IOException {
        if (this.versionFile == null) {
            throw new IOException("Version file is closed");
        }
        if (this.readOnly) {
            throw new IOException("Version file is read-only");
        }
        if (this.isPutOK(index)) {
            int vfIndex = this.vfIndexProvider.allocateIndex();
            this.versionFile.put(buf, vfIndex);
            this.bufferIndexMap.put(index, vfIndex);
            this.newMapIds.add(index);
        }
    }

    DataBuffer getOldBuffer(DataBuffer buf, int index) throws IOException {
        int vfIndex;
        if (this.versionFile == null) {
            throw new IOException("Version file is closed");
        }
        try {
            vfIndex = this.bufferIndexMap.get(index);
        }
        catch (NoValueException e) {
            return null;
        }
        this.versionFile.get(buf, vfIndex);
        return buf;
    }

    int[] getOldBufferIndexes() {
        return this.bufferIndexMap.getKeys();
    }

    long getTargetFileID() {
        return this.targetFileId;
    }

    long getOriginalFileID() {
        return this.originalFileId;
    }

    public int getOriginalBufferCount() {
        return this.originalBufCount;
    }

    String[] getOldParameterNames() throws IOException {
        if (this.versionFile == null) {
            throw new IOException("Version file is closed");
        }
        String[] allNames = this.versionFile.getParameterNames();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < allNames.length; ++i) {
            if (allNames[i].startsWith(VERSION_PARM_PREFIX)) continue;
            list.add(allNames[i]);
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    int getOldParameter(String name) throws IOException {
        if (this.versionFile == null) {
            throw new IOException("Version file is closed");
        }
        return this.versionFile.getParameter(name);
    }
}

