/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.HSLColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Objects;
import org.w3c.dom.DOMException;

class RGBColor
extends BaseColor
implements RGBAColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue red = null;
    private PrimitiveValue green = null;
    private PrimitiveValue blue = null;

    RGBColor() {
    }

    RGBColor(RGBColor copyMe) {
        this.red = copyMe.red.clone();
        this.green = copyMe.green.clone();
        this.blue = copyMe.blue.clone();
        this.setAlpha(copyMe.alpha.clone());
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.RGB;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        RGBColor rgbcolor = (RGBColor)color;
        this.red = rgbcolor.red;
        this.green = rgbcolor.green;
        this.blue = rgbcolor.blue;
    }

    @Override
    public PrimitiveValue item(int index) {
        switch (index) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getRed();
            }
            case 2: {
                return this.getGreen();
            }
            case 3: {
                return this.getBlue();
            }
        }
        return null;
    }

    @Override
    void setComponent(int index, PrimitiveValue component) {
        switch (index) {
            case 0: {
                this.setAlpha(component);
                break;
            }
            case 1: {
                this.setRed(component);
                break;
            }
            case 2: {
                this.setGreen(component);
                break;
            }
            case 3: {
                this.setBlue(component);
            }
        }
    }

    public void setRed(PrimitiveValue red) throws DOMException {
        if (red == null) {
            throw new NullPointerException();
        }
        this.red = this.enforceColorComponentType(red);
    }

    PrimitiveValue enforceColorComponentType(PrimitiveValue primi) throws DOMException {
        CSSTypedValue typed;
        PercentageEvaluator eval;
        if (primi.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)primi)));
        } else if (primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)primi)));
        }
        if (primi.getUnitType() == 0) {
            typed = (CSSTypedValue)((Object)primi);
            float fv = typed.getFloatValue((short)0);
            if (fv < 0.0f) {
                if (!typed.isCalculatedNumber()) {
                    throw new DOMException(15, "Color component cannot be smaller than zero.");
                }
                typed.setFloatValue((short)0, 0.0f);
            }
        } else if (primi.getUnitType() == 2) {
            typed = (CSSTypedValue)((Object)primi);
            float fv = typed.getFloatValue((short)2);
            if (fv < 0.0f || fv > 100.0f) {
                if (!typed.isCalculatedNumber()) {
                    throw new DOMException(15, "Color component percentage cannot be smaller than zero or greater than 100%.");
                }
                if (fv < 0.0f) {
                    typed.setFloatValue((short)2, 0.0f);
                } else {
                    typed.setFloatValue((short)2, 100.0f);
                }
            }
        } else if (!(primi.getCssValueType() == CSSValue.CssType.PROXY || primi.getPrimitiveType() == CSSValue.Type.EXPRESSION || primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || primi.getPrimitiveType() == CSSValue.Type.FUNCTION || primi.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)primi).getStringValue()))) {
            throw new DOMException(17, "Type not compatible with color component.");
        }
        return primi;
    }

    @Override
    public PrimitiveValue getRed() {
        return this.red;
    }

    public void setGreen(PrimitiveValue green) throws DOMException {
        if (green == null) {
            throw new NullPointerException();
        }
        this.green = this.enforceColorComponentType(green);
    }

    @Override
    public PrimitiveValue getGreen() {
        return this.green;
    }

    public void setBlue(PrimitiveValue blue) throws DOMException {
        if (blue == null) {
            throw new NullPointerException();
        }
        this.blue = this.enforceColorComponentType(blue);
    }

    @Override
    public PrimitiveValue getBlue() {
        return this.blue;
    }

    @Override
    boolean hasConvertibleComponents() {
        return RGBColor.isConvertibleComponent(this.getRed()) && RGBColor.isConvertibleComponent(this.getGreen()) && RGBColor.isConvertibleComponent(this.getBlue());
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] rgb = new double[]{this.rgbComponentNormalized((TypedValue)this.getRed()), this.rgbComponentNormalized((TypedValue)this.getGreen()), this.rgbComponentNormalized((TypedValue)this.getBlue())};
        return rgb;
    }

    @Override
    void setColorComponents(double[] rgb) {
        PercentageValue red = new PercentageValue();
        red.setFloatValue((short)2, (float)(rgb[0] * 100.0));
        red.setSubproperty(true);
        red.setAbsolutizedUnit();
        this.setRed(red);
        PercentageValue green = new PercentageValue();
        green.setFloatValue((short)2, (float)(rgb[1] * 100.0));
        green.setSubproperty(true);
        green.setAbsolutizedUnit();
        this.setGreen(green);
        PercentageValue blue = new PercentageValue();
        blue.setFloatValue((short)2, (float)(rgb[2] * 100.0));
        blue.setSubproperty(true);
        blue.setAbsolutizedUnit();
        this.setBlue(blue);
    }

    @Override
    double[] toSRGB(boolean clamp) throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] rgb = new double[]{this.rgbComponentNormalized((TypedValue)this.getRed()), this.rgbComponentNormalized((TypedValue)this.getGreen()), this.rgbComponentNormalized((TypedValue)this.getBlue())};
        return rgb;
    }

    @Override
    public double[] toXYZ(Illuminant white) {
        double[] rgb = this.toSRGB(true);
        double r = RGBColor.inverseSRGBCompanding(rgb[0]);
        double g = RGBColor.inverseSRGBCompanding(rgb[1]);
        double b = RGBColor.inverseSRGBCompanding(rgb[2]);
        double[] xyz = ColorUtil.linearSRGBToXYZd65(r, g, b);
        if (white == Illuminant.D50) {
            xyz = ColorUtil.d65xyzToD50(xyz);
        }
        return xyz;
    }

    public HSLColor toHSLColor() {
        HSLColorImpl hslColor = this.createHSLColor();
        this.toHSLColor(hslColor);
        return hslColor;
    }

    HSLColorImpl createHSLColor() {
        return new HSLColorImpl();
    }

    void toHSLColor(HSLColorImpl hslColor) throws DOMException {
        double[] hsl = this.toHSL();
        if (hsl == null) {
            throw new DOMException(11, "Conversion to hsl() failed.");
        }
        NumberValue h = new NumberValue();
        h.setFloatValue((short)80, (float)hsl[0]);
        h.setAbsolutizedUnit();
        PercentageValue s = new PercentageValue();
        s.setFloatValue((short)2, (float)hsl[1]);
        s.setAbsolutizedUnit();
        PercentageValue l = new PercentageValue();
        l.setFloatValue((short)2, (float)hsl[2]);
        l.setAbsolutizedUnit();
        hslColor.setHue(h);
        hslColor.setSaturation(s);
        hslColor.setLightness(l);
        hslColor.setAlpha(this.getAlpha());
    }

    double[] toHSL() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double r = this.rgbComponentNormalized((TypedValue)this.red);
        double g = this.rgbComponentNormalized((TypedValue)this.green);
        double b = this.rgbComponentNormalized((TypedValue)this.blue);
        if (r > 1.0 || g > 1.0 || b > 1.0) {
            return null;
        }
        return ColorUtil.srgbToHsl(r, g, b);
    }

    double rgbComponentNormalized(TypedValue typed) throws DOMException {
        double comp;
        short unit = typed.getUnitType();
        if (unit == 2) {
            comp = (double)typed.getFloatValue((short)2) * 0.01;
        } else if (unit == 0) {
            comp = (double)typed.getFloatValue((short)0) / 255.0;
        } else if (typed.getPrimitiveType() == CSSValue.Type.IDENT) {
            comp = 0.0;
        } else {
            throw new DOMException(17, "Wrong component: " + typed.getCssText());
        }
        return comp;
    }

    static double inverseSRGBCompanding(double compandedComponent) {
        double abs = Math.abs(compandedComponent);
        double linearComp = abs <= 0.04045 ? compandedComponent / 12.92 : Math.signum(compandedComponent) * Math.pow((abs + 0.055) / 1.055, 2.4);
        return linearComp;
    }

    @Override
    public String toString() {
        return this.oldFunctionalString(this.isNonOpaque());
    }

    String oldFunctionalString(boolean nonOpaque) {
        StringBuilder buf = new StringBuilder(25);
        if (nonOpaque) {
            buf.append("rgba(");
        } else {
            buf.append("rgb(");
        }
        this.appendComponentCssText(buf, this.getRed()).append(", ");
        this.appendComponentCssText(buf, this.getGreen()).append(", ");
        this.appendComponentCssText(buf, this.getBlue());
        if (nonOpaque) {
            buf.append(", ");
            this.appendAlphaChannel(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String toMinifiedString() {
        return this.minifiedOldFunctionalString(this.isNonOpaque());
    }

    String minifiedOldFunctionalString(boolean nonOpaque) {
        StringBuilder buf = new StringBuilder(24);
        if (nonOpaque) {
            buf.append("rgba(");
        } else {
            buf.append("rgb(");
        }
        this.appendComponentMinifiedCssText(buf, this.getRed()).append(',');
        this.appendComponentMinifiedCssText(buf, this.getGreen()).append(',');
        this.appendComponentMinifiedCssText(buf, this.getBlue());
        if (nonOpaque) {
            buf.append(',');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blue == null ? 0 : this.colorComponentHashCode(this.blue));
        result = 31 * result + (this.green == null ? 0 : this.colorComponentHashCode(this.green));
        result = 31 * result + (this.red == null ? 0 : this.colorComponentHashCode(this.red));
        result = 31 * result + this.alpha.hashCode();
        return result * 31;
    }

    private int colorComponentHashCode(PrimitiveValue comp) {
        if (comp.getPrimitiveType() != CSSValue.Type.NUMERIC) {
            return comp.hashCode();
        }
        TypedValue val = (TypedValue)comp;
        float value = comp.getUnitType() == 2 ? val.getFloatValue((short)2) * 2.55f : val.getFloatValue((short)0);
        return Float.floatToIntBits(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RGBColor)) {
            return false;
        }
        RGBColor other = (RGBColor)obj;
        if (this.blue == null ? other.blue != null : !this.blue.equals(other.blue)) {
            return false;
        }
        if (this.green == null ? other.green != null : !this.green.equals(other.green)) {
            return false;
        }
        if (this.red == null ? other.red != null : !this.red.equals(other.red)) {
            return false;
        }
        return Objects.equals(this.alpha, other.alpha);
    }

    @Override
    public ColorValue packInValue() {
        return new RGBColorValue(this);
    }

    @Override
    public RGBColor clone() {
        return new RGBColor(this);
    }
}

