/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class Range<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> comparator;
    private transient int hashCode;
    private final T maximum;
    private final T minimum;
    private transient String toString;

    @Deprecated
    public static <T extends Comparable<? super T>> Range<T> between(T fromInclusive, T toInclusive) {
        return Range.of(fromInclusive, toInclusive, null);
    }

    @Deprecated
    public static <T> Range<T> between(T fromInclusive, T toInclusive, Comparator<T> comparator2) {
        return new Range<T>(fromInclusive, toInclusive, comparator2);
    }

    public static <T extends Comparable<? super T>> Range<T> is(T element2) {
        return Range.of(element2, element2, null);
    }

    public static <T> Range<T> is(T element2, Comparator<T> comparator2) {
        return Range.of(element2, element2, comparator2);
    }

    public static <T extends Comparable<? super T>> Range<T> of(T fromInclusive, T toInclusive) {
        return Range.of(fromInclusive, toInclusive, null);
    }

    public static <T> Range<T> of(T fromInclusive, T toInclusive, Comparator<T> comparator2) {
        return new Range<T>(fromInclusive, toInclusive, comparator2);
    }

    Range(T element1, T element2, Comparator<T> comp2) {
        Objects.requireNonNull(element1, "element1");
        Objects.requireNonNull(element2, "element2");
        this.comparator = comp2 == null ? ComparableComparator.INSTANCE : comp2;
        if (this.comparator.compare(element1, element2) < 1) {
            this.minimum = element1;
            this.maximum = element2;
        } else {
            this.minimum = element2;
            this.maximum = element1;
        }
    }

    public boolean contains(T element2) {
        if (element2 == null) {
            return false;
        }
        return this.comparator.compare(element2, this.minimum) > -1 && this.comparator.compare(element2, this.maximum) < 1;
    }

    public boolean containsRange(Range<T> otherRange) {
        if (otherRange == null) {
            return false;
        }
        return this.contains(otherRange.minimum) && this.contains(otherRange.maximum);
    }

    public int elementCompareTo(T element2) {
        Objects.requireNonNull(element2, "element");
        if (this.isAfter(element2)) {
            return -1;
        }
        if (this.isBefore(element2)) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Range range2 = (Range)obj;
        return this.minimum.equals(range2.minimum) && this.maximum.equals(range2.maximum);
    }

    public T fit(T element2) {
        Objects.requireNonNull(element2, "element");
        if (this.isAfter(element2)) {
            return this.minimum;
        }
        if (this.isBefore(element2)) {
            return this.maximum;
        }
        return element2;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public T getMinimum() {
        return this.minimum;
    }

    public int hashCode() {
        int result = this.hashCode;
        if (this.hashCode == 0) {
            result = 17;
            result = 37 * result + this.getClass().hashCode();
            result = 37 * result + this.minimum.hashCode();
            this.hashCode = result = 37 * result + this.maximum.hashCode();
        }
        return result;
    }

    public Range<T> intersectionWith(Range<T> other) {
        if (!this.isOverlappedBy(other)) {
            throw new IllegalArgumentException(String.format("Cannot calculate intersection with non-overlapping range %s", other));
        }
        if (this.equals(other)) {
            return this;
        }
        T min2 = this.getComparator().compare(this.minimum, other.minimum) < 0 ? other.minimum : this.minimum;
        T max2 = this.getComparator().compare(this.maximum, other.maximum) < 0 ? this.maximum : other.maximum;
        return Range.of(min2, max2, this.getComparator());
    }

    public boolean isAfter(T element2) {
        if (element2 == null) {
            return false;
        }
        return this.comparator.compare(element2, this.minimum) < 0;
    }

    public boolean isAfterRange(Range<T> otherRange) {
        if (otherRange == null) {
            return false;
        }
        return this.isAfter(otherRange.maximum);
    }

    public boolean isBefore(T element2) {
        if (element2 == null) {
            return false;
        }
        return this.comparator.compare(element2, this.maximum) > 0;
    }

    public boolean isBeforeRange(Range<T> otherRange) {
        if (otherRange == null) {
            return false;
        }
        return this.isBefore(otherRange.minimum);
    }

    public boolean isEndedBy(T element2) {
        if (element2 == null) {
            return false;
        }
        return this.comparator.compare(element2, this.maximum) == 0;
    }

    public boolean isNaturalOrdering() {
        return this.comparator == ComparableComparator.INSTANCE;
    }

    public boolean isOverlappedBy(Range<T> otherRange) {
        if (otherRange == null) {
            return false;
        }
        return otherRange.contains(this.minimum) || otherRange.contains(this.maximum) || this.contains(otherRange.minimum);
    }

    public boolean isStartedBy(T element2) {
        if (element2 == null) {
            return false;
        }
        return this.comparator.compare(element2, this.minimum) == 0;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "[" + this.minimum + ".." + this.maximum + "]";
        }
        return this.toString;
    }

    public String toString(String format2) {
        return String.format(format2, this.minimum, this.maximum, this.comparator);
    }

    private static enum ComparableComparator implements Comparator
    {
        INSTANCE;


        public int compare(Object obj1, Object obj2) {
            return ((Comparable)obj1).compareTo(obj2);
        }
    }
}

