/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.functional.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.semanticweb.owlapi.functional.parser.Token;
import org.semanticweb.owlapi.functional.parser.TokenManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomTokenizer
implements TokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomTokenizer.class);
    private int unreadChar = -1;
    private final Reader in;
    private boolean eofSeen = false;
    private final StringBuilder buf = new StringBuilder();
    private int lineNo = 1;
    private int colNo = 0;
    private int startLine = -1;
    private int startCol = -1;

    public CustomTokenizer(Reader reader) {
        this.in = reader;
    }

    @Override
    public Token getNextToken() {
        try {
            char c;
            block13: while (true) {
                c = this.findTokenStart();
                switch (c) {
                    case '(': {
                        return this.makeToken(12, "(");
                    }
                    case ')': {
                        return this.makeToken(13, ")");
                    }
                    case '@': {
                        return this.makeToken(19, "@");
                    }
                    case '^': {
                        c = this.readChar();
                        if (c == '^') {
                            return this.makeToken(20, "^^");
                        }
                        return this.makeToken(129, "^" + c);
                    }
                    case '=': {
                        return this.makeToken(118, "=");
                    }
                    case '#': {
                        this.skipComment();
                        continue block13;
                    }
                    case '\"': {
                        return this.readStringLiteralToken();
                    }
                    case '<': {
                        return this.readFullIRI();
                    }
                }
                break;
            }
            return this.readTextualToken(c);
        }
        catch (EOFException e) {
            return this.makeToken(0, "");
        }
        catch (IOException e) {
            LOGGER.warn("IOException reading from functioanl stream", (Throwable)e);
            return this.makeToken(0, "");
        }
    }

    private void skipComment() throws IOException {
        char c = this.readChar();
        while (c != '\n') {
            c = this.readChar();
        }
    }

    private Token readStringLiteralToken() throws IOException {
        this.buf.setLength(0);
        this.buf.append('\"');
        while (true) {
            char c = this.readChar();
            switch (c) {
                case '\"': {
                    this.buf.append(c);
                    return this.makeToken(11, this.buf.toString());
                }
                case '\\': {
                    this.buf.append(c);
                    c = this.readChar();
                    if (c == '\\' || c == '\"') break;
                    return this.makeToken(129, "Bad escape sequence in StringLiteral");
                }
            }
            this.buf.append(c);
        }
    }

    private Token readFullIRI() {
        try {
            char c;
            this.buf.setLength(0);
            this.buf.append('<');
            do {
                c = this.readChar();
                this.buf.append(c);
            } while (c != '>');
            return this.makeToken(120, this.buf.toString());
        }
        catch (IOException e) {
            LOGGER.warn("IOException reading from functioanl stream", (Throwable)e);
            return this.makeToken(129, "<");
        }
    }

    private Token readTextualToken(char input) throws IOException {
        int colonIndex;
        block218: {
            char c = input;
            if (c >= '0' && c <= '9') {
                return this.readNumber(c);
            }
            this.buf.setLength(0);
            this.buf.append(c);
            colonIndex = -1;
            if (c == ':') {
                colonIndex = 0;
            }
            try {
                while (true) {
                    c = this.readChar();
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case '\"': 
                        case '(': 
                        case ')': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '@': 
                        case '^': {
                            this.unread(c);
                            break block218;
                        }
                        case ':': {
                            colonIndex = this.buf.length();
                        }
                        default: {
                            this.buf.append(c);
                            break;
                        }
                    }
                }
            }
            catch (EOFException eof) {
                // empty catch block
            }
        }
        String s = this.buf.toString();
        if (colonIndex >= 0) {
            if (colonIndex == s.length() - 1) {
                return this.makeToken(121, s);
            }
            if (s.startsWith("_:")) {
                return this.makeToken(128, s);
            }
            return this.makeToken(123, s);
        }
        switch (s) {
            case "Ontology": {
                return this.makeToken(14, s);
            }
            case "Label": {
                return this.makeToken(15, s);
            }
            case "Import": {
                return this.makeToken(16, s);
            }
            case "Comment": {
                return this.makeToken(17, s);
            }
            case "SubClassOf": {
                return this.makeToken(18, s);
            }
            case "EquivalentClasses": {
                return this.makeToken(21, s);
            }
            case "DisjointClasses": {
                return this.makeToken(22, s);
            }
            case "DisjointUnion": {
                return this.makeToken(23, s);
            }
            case "Annotation": {
                return this.makeToken(24, s);
            }
            case "AnnotationProperty": {
                return this.makeToken(25, s);
            }
            case "AnnotationAssertion": {
                return this.makeToken(26, s);
            }
            case "SubAnnotationPropertyOf": {
                return this.makeToken(27, s);
            }
            case "AnnotationPropertyDomain": {
                return this.makeToken(28, s);
            }
            case "AnnotationPropertyRange": {
                return this.makeToken(29, s);
            }
            case "HasKey": {
                return this.makeToken(30, s);
            }
            case "Declaration": {
                return this.makeToken(31, s);
            }
            case "Documentation": {
                return this.makeToken(32, s);
            }
            case "Class": {
                return this.makeToken(33, s);
            }
            case "ObjectProperty": {
                return this.makeToken(34, s);
            }
            case "DataProperty": {
                return this.makeToken(35, s);
            }
            case "NamedIndividual": {
                return this.makeToken(36, s);
            }
            case "Datatype": {
                return this.makeToken(37, s);
            }
            case "DataOneOf": {
                return this.makeToken(38, s);
            }
            case "DataUnionOf": {
                return this.makeToken(39, s);
            }
            case "DataIntersectionOf": {
                return this.makeToken(40, s);
            }
            case "ObjectOneOf": {
                return this.makeToken(41, s);
            }
            case "ObjectUnionOf": {
                return this.makeToken(42, s);
            }
            case "ObjectHasValue": {
                return this.makeToken(43, s);
            }
            case "ObjectInverseOf": {
                return this.makeToken(44, s);
            }
            case "InverseObjectProperties": {
                return this.makeToken(45, s);
            }
            case "DataComplementOf": {
                return this.makeToken(46, s);
            }
            case "DatatypeRestriction": {
                return this.makeToken(47, s);
            }
            case "DatatypeDefinition": {
                return this.makeToken(48, s);
            }
            case "ObjectIntersectionOf": {
                return this.makeToken(49, s);
            }
            case "ObjectComplementOf": {
                return this.makeToken(50, s);
            }
            case "ObjectAllValuesFrom": {
                return this.makeToken(51, s);
            }
            case "ObjectSomeValuesFrom": {
                return this.makeToken(52, s);
            }
            case "ObjectHasSelf": {
                return this.makeToken(53, s);
            }
            case "ObjectMinCardinality": {
                return this.makeToken(54, s);
            }
            case "ObjectMaxCardinality": {
                return this.makeToken(55, s);
            }
            case "ObjectExactCardinality": {
                return this.makeToken(56, s);
            }
            case "DataAllValuesFrom": {
                return this.makeToken(57, s);
            }
            case "DataSomeValuesFrom": {
                return this.makeToken(58, s);
            }
            case "DataHasValue": {
                return this.makeToken(59, s);
            }
            case "DataMinCardinality": {
                return this.makeToken(60, s);
            }
            case "DataMaxCardinality": {
                return this.makeToken(61, s);
            }
            case "DataExactCardinality": {
                return this.makeToken(62, s);
            }
            case "ObjectPropertyChain": {
                return this.makeToken(63, s);
            }
            case "SubObjectPropertyOf": {
                return this.makeToken(64, s);
            }
            case "EquivalentObjectProperties": {
                return this.makeToken(65, s);
            }
            case "DisjointObjectProperties": {
                return this.makeToken(66, s);
            }
            case "ObjectPropertyDomain": {
                return this.makeToken(67, s);
            }
            case "ObjectPropertyRange": {
                return this.makeToken(68, s);
            }
            case "FunctionalObjectProperty": {
                return this.makeToken(69, s);
            }
            case "InverseFunctionalObjectProperty": {
                return this.makeToken(70, s);
            }
            case "ReflexiveObjectProperty": {
                return this.makeToken(71, s);
            }
            case "IrreflexiveObjectProperty": {
                return this.makeToken(72, s);
            }
            case "SymmetricObjectProperty": {
                return this.makeToken(73, s);
            }
            case "AsymmetricObjectProperty": {
                return this.makeToken(74, s);
            }
            case "TransitiveObjectProperty": {
                return this.makeToken(75, s);
            }
            case "SubDataPropertyOf": {
                return this.makeToken(76, s);
            }
            case "EquivalentDataProperties": {
                return this.makeToken(77, s);
            }
            case "DisjointDataProperties": {
                return this.makeToken(78, s);
            }
            case "DataPropertyDomain": {
                return this.makeToken(79, s);
            }
            case "DataPropertyRange": {
                return this.makeToken(80, s);
            }
            case "FunctionalDataProperty": {
                return this.makeToken(81, s);
            }
            case "SameIndividual": {
                return this.makeToken(82, s);
            }
            case "DifferentIndividuals": {
                return this.makeToken(83, s);
            }
            case "ClassAssertion": {
                return this.makeToken(84, s);
            }
            case "ObjectPropertyAssertion": {
                return this.makeToken(85, s);
            }
            case "NegativeObjectPropertyAssertion": {
                return this.makeToken(86, s);
            }
            case "DataPropertyAssertion": {
                return this.makeToken(87, s);
            }
            case "NegativeDataPropertyAssertion": {
                return this.makeToken(88, s);
            }
            case "Prefix": {
                return this.makeToken(89, s);
            }
            case "length": {
                return this.makeToken(90, s);
            }
            case "minLength": {
                return this.makeToken(91, s);
            }
            case "maxLength": {
                return this.makeToken(92, s);
            }
            case "pattern": {
                return this.makeToken(93, s);
            }
            case "minInclusive": {
                return this.makeToken(94, s);
            }
            case "maxInclusive": {
                return this.makeToken(95, s);
            }
            case "minExclusive": {
                return this.makeToken(96, s);
            }
            case "maxExclusive": {
                return this.makeToken(97, s);
            }
            case "totalDigits": {
                return this.makeToken(98, s);
            }
            case "DLSafeRule": {
                return this.makeToken(100, s);
            }
            case "Body": {
                return this.makeToken(101, s);
            }
            case "Head": {
                return this.makeToken(102, s);
            }
            case "ClassAtom": {
                return this.makeToken(103, s);
            }
            case "DataRangeAtom": {
                return this.makeToken(104, s);
            }
            case "ObjectPropertyAtom": {
                return this.makeToken(105, s);
            }
            case "DataPropertyAtom": {
                return this.makeToken(106, s);
            }
            case "BuiltInAtom": {
                return this.makeToken(107, s);
            }
            case "SameIndividualAtom": {
                return this.makeToken(108, s);
            }
            case "DifferentIndividualsAtom": {
                return this.makeToken(109, s);
            }
            case "Variable": {
                return this.makeToken(110, s);
            }
            case "DescriptionGraphRule": {
                return this.makeToken(111, s);
            }
            case "DescriptionGraph": {
                return this.makeToken(112, s);
            }
            case "Nodes": {
                return this.makeToken(113, s);
            }
            case "NodeAssertion": {
                return this.makeToken(114, s);
            }
            case "Edges": {
                return this.makeToken(115, s);
            }
            case "EdgeAssertion": {
                return this.makeToken(116, s);
            }
            case "MainClasses": {
                return this.makeToken(117, s);
            }
        }
        return this.makeToken(122, s);
    }

    private Token readNumber(char input) throws IOException {
        char c = input;
        this.buf.setLength(0);
        this.buf.append(c);
        while (true) {
            if (!Character.isDigit(c = this.readChar())) {
                this.unread(c);
                return this.makeToken(119, this.buf.toString());
            }
            this.buf.append(c);
        }
    }

    private Token makeToken(int kind, String image) {
        Token result = new Token(kind, image);
        result.beginLine = this.startLine;
        result.beginColumn = this.startCol;
        return result;
    }

    private char findTokenStart() throws IOException {
        char c;
        while ((c = this.readChar()) == ' ' || c == '\t' || c == '\r' || c == '\n') {
        }
        this.startLine = this.lineNo;
        this.startCol = this.colNo;
        return c;
    }

    private void unread(char c) {
        this.unreadChar = c;
        if (c != '\n') {
            --this.colNo;
        }
    }

    private char readChar() throws IOException {
        int c;
        if (this.eofSeen) {
            throw new EOFException();
        }
        if (this.unreadChar < 0) {
            c = this.in.read();
            if (c == 10) {
                ++this.lineNo;
                this.colNo = 0;
            }
        } else {
            c = this.unreadChar;
            this.unreadChar = -1;
        }
        ++this.colNo;
        if (c < 0) {
            this.eofSeen = true;
            throw new EOFException();
        }
        return (char)c;
    }
}

