/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.command.PSystemSingleLineFactory;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.version.PSystemKeycheck;
import net.sourceforge.plantuml.version.PSystemKeygen;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory
extends PSystemSingleLineFactory {
    @Override
    protected AbstractPSystem executeLine(UmlSource source, String line, PreprocessingArtifact preprocessing) {
        try {
            Pattern p;
            Matcher m4;
            if (line.matches("(?i)^(authors?|about)\\s*$")) {
                return PSystemVersion.createShowAuthors2(source, preprocessing);
            }
            if (line.matches("(?i)^version\\s*$")) {
                return PSystemVersion.createShowVersion2(source, preprocessing);
            }
            if (line.matches("(?i)^stdlib\\s*$")) {
                return PSystemVersion.createStdLib(source, preprocessing);
            }
            if (line.matches("(?i)^testdot\\s*$")) {
                return PSystemVersion.createTestDot(source, preprocessing);
            }
            if (line.matches("(?i)^keydistributor\\s*$")) {
                return PSystemVersion.createKeyDistributor(source, preprocessing);
            }
            if (line.matches("(?i)^keygen\\s*$")) {
                line = line.trim();
                return new PSystemKeygen(source, "", preprocessing);
            }
            if (line.matches("(?i)^keyimport(\\s+[0-9a-z]+)?\\s*$")) {
                line = line.trim();
                String key = line.substring("keyimport".length()).trim();
                return new PSystemKeygen(source, key, preprocessing);
            }
            if (line.matches("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$") && (m4 = (p = Pattern.compile("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$")).matcher(line)).find()) {
                return new PSystemKeycheck(source, m4.group(1), m4.group(2), preprocessing);
            }
        }
        catch (Exception e) {
            Log.error("Error " + e);
        }
        return null;
    }
}

