/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.brotli.BrotliInputStream;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.utils.Base64Coder;
import net.sourceforge.plantuml.utils.Log;

public class Stdlib {
    private static final Map<String, Stdlib> all = new ConcurrentHashMap<String, Stdlib>();
    private static final String SEPARATOR = "\uf8ff";
    private static final Pattern sizePattern = Pattern.compile("\\[(\\d+)x(\\d+)/16\\]");
    private final Map<String, SoftReference<String>> cache = new ConcurrentHashMap<String, SoftReference<String>>();
    private final String name;
    private final Map<String, String> info = new HashMap<String, String>();

    private Stdlib(String name, String info) throws IOException {
        this.name = name;
        this.fillMap(info);
    }

    private void fillMap(String infoString) {
        for (String s2 : infoString.split("\n")) {
            String[] data;
            if (!s2.contains("=") || (data = s2.split("=")).length != 2) continue;
            this.info.put(data[0], data[1]);
        }
    }

    public static InputStream getResourceAsStream(String fullname) {
        int last = (fullname = fullname.toLowerCase().replace(".puml", "")).indexOf(47);
        if (last == -1) {
            return null;
        }
        try {
            Stdlib folder = Stdlib.retrieve(fullname.substring(0, last));
            if (folder == null || folder.info.size() == 0) {
                return null;
            }
            String data = folder.loadResource(fullname.substring(last + 1));
            if (data == null) {
                return null;
            }
            return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    public static Stdlib retrieve(String name) throws IOException {
        Stdlib result = all.get(name);
        if (result == null) {
            DataInputStream dataStream = Stdlib.getDataStream(name);
            if (dataStream == null) {
                return null;
            }
            String info = dataStream.readUTF();
            dataStream.close();
            String link = Stdlib.getLinkFromInfo(info);
            result = link == null ? new Stdlib(name, info) : Stdlib.retrieve(link);
            all.put(name, result);
        }
        return result;
    }

    private static String getLinkFromInfo(String infoString) {
        for (String s2 : infoString.split("\n")) {
            String[] data;
            if (!s2.contains("=") || !(data = s2.split("="))[0].equalsIgnoreCase("link")) continue;
            return data[1];
        }
        return null;
    }

    private static int read1byte(InputStream is) throws IOException {
        return is.read() & 0xFF;
    }

    private static int read2bytes(InputStream is) throws IOException {
        return (Stdlib.read1byte(is) << 8) + Stdlib.read1byte(is);
    }

    public String loadResource(String file) throws IOException {
        String cachedResult;
        SoftReference<String> cached = this.cache.get(file.toLowerCase());
        if (cached != null && (cachedResult = cached.get()) != null) {
            return cachedResult;
        }
        Log.info("No cache for " + file);
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return null;
        }
        dataStream.readUTF();
        InputStream spriteStream = this.getSpriteStream();
        if (spriteStream == null) {
            dataStream.close();
            return null;
        }
        InputStream dataImagePngBase64Stream = null;
        ArrayList<Integer> colors = new ArrayList<Integer>();
        try {
            StringBuilder found = null;
            block5: while (true) {
                String filename;
                if ((filename = dataStream.readUTF()).equals(SEPARATOR)) {
                    Log.info("Not found " + filename);
                    String string = null;
                    return string;
                }
                if (filename.equalsIgnoreCase(file)) {
                    found = new StringBuilder();
                }
                while (true) {
                    String s2;
                    if ((s2 = dataStream.readUTF()).equals(SEPARATOR)) {
                        if (found == null) continue block5;
                        String result = found.toString();
                        this.cache.put(file.toLowerCase(), new SoftReference<String>(result));
                        String string = result;
                        return string;
                    }
                    if (s2.contains("data:image/png;base64,")) {
                        if (dataImagePngBase64Stream == null) {
                            dataImagePngBase64Stream = this.getDataImagePngBase64();
                            int size = Stdlib.read2bytes(dataImagePngBase64Stream);
                            for (int i = 0; i < size; ++i) {
                                int alpha = Stdlib.read1byte(dataImagePngBase64Stream);
                                int red = Stdlib.read1byte(dataImagePngBase64Stream);
                                int green = Stdlib.read1byte(dataImagePngBase64Stream);
                                int blue = Stdlib.read1byte(dataImagePngBase64Stream);
                                int rgb = (alpha << 24) + (red << 16) + (green << 8) + blue;
                                colors.add(rgb);
                            }
                        }
                        String base64 = this.readOneImage(dataImagePngBase64Stream, colors);
                        s2 = s2.replaceFirst("data:image/png;base64,", "data:image/png;base64," + base64);
                    }
                    if (found != null) {
                        found.append(s2);
                        found.append("\n");
                    }
                    if (!this.isSpriteLine(s2)) continue;
                    Matcher m4 = sizePattern.matcher(s2);
                    boolean ok = m4.find();
                    if (!ok) {
                        throw new IOException(s2);
                    }
                    int width = Integer.parseInt(m4.group(1));
                    int height = Integer.parseInt(m4.group(2));
                    if (found == null) {
                        this.skipSprite(width, height, spriteStream);
                        continue;
                    }
                    String sprite = this.readSprite(width, height, spriteStream);
                    found.append(sprite);
                    found.append("}\n");
                }
                break;
            }
        }
        finally {
            dataStream.close();
            spriteStream.close();
            if (dataImagePngBase64Stream != null) {
                dataImagePngBase64Stream.close();
            }
        }
    }

    private String readOneImage(InputStream is, List<Integer> colors) throws IOException {
        int width = is.read();
        int height = is.read();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = colors.get(Stdlib.read2bytes(is));
                result.setRGB(x, y, rgb);
            }
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)result, "png", baos);
            String string = new String(Base64Coder.encode(baos.toByteArray()));
            return string;
        }
    }

    private void skipSprite(int width, int height, InputStream inputStream) throws IOException {
        int nbLines = (height + 1) / 2;
        inputStream.skip(nbLines * width);
    }

    private String readSprite(int width, int height, InputStream inputStream) throws IOException {
        int nbLines = (height + 1) / 2;
        StringBuilder result = new StringBuilder();
        int line = 0;
        for (int j = 0; j < nbLines; ++j) {
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            for (int i = 0; i < width; ++i) {
                int b = inputStream.read();
                int b1 = (b & 0xF0) >> 4;
                int b2 = b & 0xF;
                sb1.append(this.toHexString(b1));
                sb2.append(this.toHexString(b2));
            }
            result.append(sb1.toString());
            result.append("\n");
            if (++line >= height) continue;
            result.append(sb2.toString());
            result.append("\n");
            ++line;
        }
        return result.toString();
    }

    private String toHexString(int b) {
        return Integer.toHexString(b).toUpperCase();
    }

    private boolean isSpriteLine(String s2) {
        return s2.trim().startsWith("sprite") && s2.trim().endsWith("{");
    }

    private static DataInputStream getDataStream(String name) throws IOException {
        InputStream raw = Stdlib.getInternalInputStream(name, "-abx.repx");
        if (raw == null) {
            return null;
        }
        return new DataInputStream(new BrotliInputStream(raw));
    }

    private DataInputStream getDataStream() throws IOException {
        return Stdlib.getDataStream(this.name);
    }

    private InputStream getSpriteStream() throws IOException {
        InputStream raw = Stdlib.getInternalInputStream(this.name, "-dex.repx");
        if (raw == null) {
            return null;
        }
        return new BrotliInputStream(raw);
    }

    private InputStream getDataImagePngBase64() throws IOException {
        InputStream raw = Stdlib.getInternalInputStream(this.name, "-ghx.repx");
        if (raw == null) {
            return null;
        }
        return new BrotliInputStream(raw);
    }

    private static InputStream getInternalInputStream(String fullname, String extension) throws FileNotFoundException {
        String path = "stdlib/" + fullname + extension;
        InputStream result = Stdlib.class.getResourceAsStream("/" + path);
        if (result == null) {
            result = new BufferedInputStream(new FileInputStream(path));
        }
        return result;
    }

    public static void extractStdLib() throws IOException {
        for (String name : Stdlib.getAllFolderNames()) {
            Stdlib folder = Stdlib.retrieve(name);
            folder.extractMeFull();
        }
    }

    public static Collection<String> getAllFolderNames() throws IOException {
        String name;
        TreeSet<String> result = new TreeSet<String>();
        InputStream home = Stdlib.getInternalInputStream("home", ".repx");
        if (home == null) {
            throw new IOException("Cannot access to /stdlib/*.repx files");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(home));
        while ((name = br.readLine()) != null) {
            result.add(name);
        }
        return Collections.unmodifiableCollection(result);
    }

    private void extractMeFull() throws IOException {
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return;
        }
        dataStream.readUTF();
        InputStream spriteStream = this.getSpriteStream();
        try {
            while (true) {
                String s2;
                String filename;
                if ((filename = dataStream.readUTF()).equals(SEPARATOR)) {
                    return;
                }
                SFile f = new SFile("stdlib/" + this.name + "/" + filename + ".puml");
                f.getParentFile().mkdirs();
                PrintWriter fos = f.createPrintWriter();
                while (!(s2 = dataStream.readUTF()).equals(SEPARATOR)) {
                    fos.println(s2);
                    if (!this.isSpriteLine(s2)) continue;
                    Matcher m4 = sizePattern.matcher(s2);
                    boolean ok = m4.find();
                    if (!ok) {
                        throw new IOException(s2);
                    }
                    int width = Integer.parseInt(m4.group(1));
                    int height = Integer.parseInt(m4.group(2));
                    String sprite = this.readSprite(width, height, spriteStream);
                    fos.println(sprite);
                    fos.println("}");
                }
                fos.close();
            }
        }
        finally {
            dataStream.close();
            spriteStream.close();
        }
    }

    public Collection<String> getAllFilenamesWithSprites() throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return result;
        }
        dataStream.readUTF();
        try {
            block4: while (true) {
                String filename;
                if ((filename = dataStream.readUTF()).equals(SEPARATOR)) {
                    TreeSet<String> treeSet = result;
                    return treeSet;
                }
                while (true) {
                    String s2;
                    if ((s2 = dataStream.readUTF()).equals(SEPARATOR)) continue block4;
                    if (!this.isSpriteLine(s2)) continue;
                    result.add(filename);
                }
                break;
            }
        }
        finally {
            dataStream.close();
        }
    }

    public List<String> extractAllSprites() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return Collections.unmodifiableList(result);
        }
        dataStream.readUTF();
        InputStream spriteStream = this.getSpriteStream();
        try {
            block4: while (true) {
                String filename;
                if ((filename = dataStream.readUTF()).equals(SEPARATOR)) {
                    List<String> list = Collections.unmodifiableList(result);
                    return list;
                }
                while (true) {
                    String s2;
                    if ((s2 = dataStream.readUTF()).equals(SEPARATOR)) continue block4;
                    if (!this.isSpriteLine(s2)) continue;
                    Matcher m4 = sizePattern.matcher(s2);
                    boolean ok = m4.find();
                    if (!ok) {
                        throw new IOException(s2);
                    }
                    int width = Integer.parseInt(m4.group(1));
                    int height = Integer.parseInt(m4.group(2));
                    String sprite = this.readSprite(width, height, spriteStream);
                    if (s2.contains("_LARGE")) continue;
                    result.add(s2 + "\n" + sprite + "}");
                }
                break;
            }
        }
        finally {
            dataStream.close();
            spriteStream.close();
        }
    }

    public static void addInfoVersion(List<String> strings, boolean details) {
        try {
            for (String name : Stdlib.getAllFolderNames()) {
                Stdlib folder = Stdlib.retrieve(name);
                if (details) {
                    strings.add("<b>" + name);
                    strings.add("Version " + folder.getVersion());
                    strings.add("Delivered by " + folder.getSource());
                    strings.add(" ");
                    continue;
                }
                strings.add("* " + name + " (Version " + folder.getVersion() + ")");
            }
        }
        catch (IOException e) {
            Log.error("Error " + e);
            return;
        }
    }

    public String getVersion() {
        String result = this.info.get("VERSION");
        if (result == null) {
            result = this.info.get("version");
        }
        return result;
    }

    public String getSource() {
        String result = this.info.get("SOURCE");
        if (result == null) {
            result = this.info.get("source");
        }
        return result;
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.info);
    }

    public static void printStdLib() {
        ArrayList<String> print = new ArrayList<String>();
        Stdlib.addInfoVersion(print, true);
        for (String s2 : print) {
            System.out.println(s2.replace("<b>", ""));
        }
    }
}

