/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.geom;

import java.awt.Dimension;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class XDimension2D {
    private final double width;
    private final double height;

    public XDimension2D(double width, double height) {
        if (width < 0.0) {
            throw new IllegalArgumentException();
        }
        if (height < 0.0) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(width) || Double.isNaN(height)) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "[" + this.width + "," + this.height + "]";
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public XDimension2D delta(double delta) {
        return this.delta(delta, delta);
    }

    public XDimension2D withWidth(double newWidth) {
        return new XDimension2D(newWidth, this.height);
    }

    public XDimension2D applyTranslate(UTranslate translate) {
        return new XDimension2D(this.width + translate.getDx(), this.height + translate.getDy());
    }

    public XDimension2D delta(double deltaWidth, double deltaHeight) {
        if (deltaHeight == 0.0 && deltaWidth == 0.0) {
            return this;
        }
        return new XDimension2D(this.getWidth() + deltaWidth, this.getHeight() + deltaHeight);
    }

    public XDimension2D mergeTB(XDimension2D bottom) {
        double width = Math.max(this.getWidth(), bottom.getWidth());
        double height = this.getHeight() + bottom.getHeight();
        return new XDimension2D(width, height);
    }

    public XDimension2D mergeTB(XDimension2D b, XDimension2D c) {
        double width = MathUtils.max(this.getWidth(), b.getWidth(), c.getWidth());
        double height = this.getHeight() + b.getHeight() + c.getHeight();
        return new XDimension2D(width, height);
    }

    public XDimension2D mergeLR(XDimension2D right) {
        double height = Math.max(this.getHeight(), right.getHeight());
        double width = this.getWidth() + right.getWidth();
        return new XDimension2D(width, height);
    }

    public XDimension2D atLeast(double minWidth, double minHeight) {
        double h2 = this.getHeight();
        double w = this.getWidth();
        if (w > minWidth && h2 > minHeight) {
            return this;
        }
        if (h2 < minHeight) {
            h2 = minHeight;
        }
        if (w < minWidth) {
            w = minWidth;
        }
        return new XDimension2D(w, h2);
    }

    public static XDimension2D fromDimension(Dimension dimension) {
        return new XDimension2D(dimension.getWidth(), dimension.getHeight());
    }

    public static XDimension2D mergeLayoutT12B3(XDimension2D top1, XDimension2D top2, XDimension2D bottom) {
        double width = MathUtils.max(top1.getWidth(), top2.getWidth(), bottom.getWidth());
        double height = top1.getHeight() + top2.getHeight() + bottom.getHeight();
        return new XDimension2D(width, height);
    }

    public static XDimension2D max(XDimension2D dim1, XDimension2D dim2) {
        return dim1.atLeast(dim2.getWidth(), dim2.getHeight());
    }
}

