/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.Content;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.StaxUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;

public class ContentStaxUnmarshaller
implements Unmarshaller<Content, StaxUnmarshallerContext> {
    private static ContentStaxUnmarshaller instance;

    @Override
    public Content unmarshall(StaxUnmarshallerContext context) throws Exception {
        Content content = new Content();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return content;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Data", targetDepth)) {
                    content.setData(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Charset", targetDepth)) continue;
                content.setCharset(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return content;
    }

    public static ContentStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ContentStaxUnmarshaller();
        }
        return instance;
    }
}

