"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSpacer", {
  enumerable: true,
  get: function get() {
    return _spacer.EuiSpacer;
  }
});
exports.OuiSpacer = exports.SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _spacer = require("../../eui_components/spacer/spacer");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sizeToClassNameMap = {
  xs: 'ouiSpacer--xs',
  s: 'ouiSpacer--s',
  m: 'ouiSpacer--m',
  l: 'ouiSpacer--l',
  xl: 'ouiSpacer--xl',
  xxl: 'ouiSpacer--xxl'
};
var SIZES = Object.keys(sizeToClassNameMap);
exports.SIZES = SIZES;

var OuiSpacer = function OuiSpacer(_ref) {
  var className = _ref.className,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'l' : _ref$size,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "size"]);
  var classes = (0, _classnames.default)('ouiSpacer', sizeToClassNameMap[size], className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiSpacer = OuiSpacer;
OuiSpacer.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  size: _propTypes.default.oneOf(["xs", "s", "m", "l", "xl", "xxl"])
};
/* OUI -> EUI Aliases: Build-Time */