/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.parser;

import com.hankcs.hanlp.dependency.perceptron.learning.AveragedPerceptron;
import com.hankcs.hanlp.dependency.perceptron.structures.IndexMaps;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Configuration;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.State;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.Action;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.TransitionBasedParser;
import java.util.ArrayList;

public class ArcEager
extends TransitionBasedParser {
    private ArcEager(AveragedPerceptron classifier, ArrayList<Integer> dependencyRelations, int featureLength, IndexMaps maps) {
        super(classifier, dependencyRelations, featureLength, maps);
    }

    public static void shift(State state) {
        state.push(state.bufferHead());
        state.incrementBufferHead();
        if (state.bufferEmpty()) {
            state.setEmptyFlag(true);
        }
    }

    public static void unShift(State state) {
        if (!state.stackEmpty()) {
            state.setBufferHead(state.pop());
        }
        state.setEmptyFlag(true);
        state.setMaxSentenceSize(state.bufferHead());
    }

    public static void reduce(State state) {
        state.pop();
        if (state.stackEmpty() && state.bufferEmpty()) {
            state.setEmptyFlag(true);
        }
    }

    public static void leftArc(State state, int dependency) {
        state.addArc(state.pop(), state.bufferHead(), dependency);
    }

    public static void rightArc(State state, int dependency) {
        state.addArc(state.bufferHead(), state.stackTop(), dependency);
        state.push(state.bufferHead());
        state.incrementBufferHead();
        if (!state.isEmptyFlag() && state.bufferEmpty()) {
            state.setEmptyFlag(true);
        }
    }

    public static boolean canDo(Action action, State state) {
        if (action == Action.Shift) {
            return (state.bufferEmpty() || state.bufferHead() != state.rootIndex || state.stackEmpty()) && !state.bufferEmpty() && !state.isEmptyFlag();
        }
        if (action == Action.RightArc) {
            if (state.stackEmpty()) {
                return false;
            }
            return (state.bufferEmpty() || state.bufferHead() != state.rootIndex) && !state.bufferEmpty() && !state.stackEmpty();
        }
        if (action == Action.LeftArc) {
            if (state.stackEmpty() || state.bufferEmpty()) {
                return false;
            }
            if (!state.stackEmpty() && state.stackTop() == state.rootIndex) {
                return false;
            }
            return state.stackTop() != state.rootIndex && !state.hasHead(state.stackTop()) && !state.stackEmpty();
        }
        if (action == Action.Reduce) {
            return !state.stackEmpty() && state.hasHead(state.stackTop()) || !state.stackEmpty() && state.stackSize() == 1 && state.bufferSize() == 0 && state.stackTop() == state.rootIndex;
        }
        if (action == Action.Unshift) {
            return !state.stackEmpty() && !state.hasHead(state.stackTop()) && state.isEmptyFlag();
        }
        return false;
    }

    public static boolean isTerminal(ArrayList<Configuration> beam) {
        for (Configuration configuration : beam) {
            if (configuration.state.isTerminalState()) continue;
            return false;
        }
        return true;
    }

    public static void commitAction(int action, int label, float score, ArrayList<Integer> dependencyRelations, Configuration newConfig) {
        if (action == 0) {
            ArcEager.shift(newConfig.state);
            newConfig.addAction(0);
        } else if (action == 1) {
            ArcEager.reduce(newConfig.state);
            newConfig.addAction(1);
        } else if (action == 2) {
            ArcEager.rightArc(newConfig.state, label);
            newConfig.addAction(3 + label);
        } else if (action == 3) {
            ArcEager.leftArc(newConfig.state, label);
            newConfig.addAction(3 + dependencyRelations.size() + label);
        } else if (action == 4) {
            ArcEager.unShift(newConfig.state);
            newConfig.addAction(2);
        }
        newConfig.setScore(score);
    }
}

