/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.FailureMessages;
import com.tngtech.archunit.lang.FailureReport;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.ViolationHandler;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Ordering;
import com.tngtech.archunit.thirdparty.com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class EvaluationResult {
    static final String ARCHUNIT_IGNORE_PATTERNS_FILE_NAME = "archunit_ignore_patterns.txt";
    private static final String COMMENT_LINE_PREFIX = "#";
    private final HasDescription rule;
    private final ArrayList<ConditionEvent> violations;
    private final Optional<String> informationAboutNumberOfViolations;
    private final Priority priority;

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult(HasDescription rule, Priority priority) {
        this(rule, new ArrayList<ConditionEvent>(), Optional.empty(), priority);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult(HasDescription rule, ConditionEvents events, Priority priority) {
        this(rule, new ArrayList<ConditionEvent>(events.getViolating()), events.getInformationAboutNumberOfViolations(), priority);
    }

    private EvaluationResult(HasDescription rule, ArrayList<ConditionEvent> violations, Optional<String> informationAboutNumberOfViolations, Priority priority) {
        this.rule = rule;
        this.violations = EvaluationResult.createViolations(violations);
        this.informationAboutNumberOfViolations = informationAboutNumberOfViolations;
        this.priority = priority;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public FailureReport getFailureReport() {
        ImmutableList<String> result = this.violations.stream().flatMap(event -> event.getDescriptionLines().stream()).sorted(Ordering.natural()).collect(ImmutableList.toImmutableList());
        FailureMessages failureMessages = new FailureMessages(result, this.informationAboutNumberOfViolations);
        return new FailureReport(this.rule, this.priority, failureMessages);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void add(EvaluationResult part) {
        this.violations.addAll(part.violations);
    }

    @SafeVarargs
    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public final <T> void handleViolations(ViolationHandler<T> violationHandler, T ... __ignored_parameter_to_reify_type__) {
        Class<T> correspondingObjectType = this.componentTypeOf(__ignored_parameter_to_reify_type__);
        ConditionEvent.Handler eventHandler = this.convertToEventHandler(correspondingObjectType, violationHandler);
        for (ConditionEvent event : this.violations) {
            event.handleWith(eventHandler);
        }
    }

    private <T> Class<T> componentTypeOf(T[] array) {
        return array.getClass().getComponentType();
    }

    private <ITEM> ConditionEvent.Handler convertToEventHandler(Class<? extends ITEM> correspondingObjectType, ViolationHandler<ITEM> violationHandler) {
        return (correspondingObjects, message) -> {
            if (this.allElementTypesMatch(correspondingObjects, correspondingObjectType)) {
                ImmutableList collection = ImmutableList.copyOf(correspondingObjects);
                violationHandler.handle(collection, message);
            }
        };
    }

    private boolean allElementTypesMatch(Collection<?> violatingObjects, Class<?> supportedElementType) {
        return violatingObjects.stream().allMatch(supportedElementType::isInstance);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean hasViolation() {
        return !this.violations.isEmpty();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Priority getPriority() {
        return this.priority;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult filterDescriptionsMatching(Predicate<String> linePredicate) {
        ArrayList<ConditionEvent> filtered = EvaluationResult.filterEvents(this.violations, linePredicate);
        return new EvaluationResult(this.rule, filtered, Optional.empty(), this.priority);
    }

    private static ArrayList<ConditionEvent> filterEvents(Collection<ConditionEvent> violations, Predicate<String> linePredicate) {
        return violations.stream().map(e -> new FilteredEvent((ConditionEvent)e, linePredicate)).filter(FilteredEvent::isViolation).collect(Collectors.toCollection(ArrayList::new));
    }

    private static ArrayList<ConditionEvent> createViolations(ArrayList<ConditionEvent> violations) {
        Set<Pattern> patterns = EvaluationResult.readPatternsFrom(ARCHUNIT_IGNORE_PATTERNS_FILE_NAME);
        return patterns.isEmpty() ? violations : EvaluationResult.filterEvents(violations, EvaluationResult.notMatchedByAny(patterns));
    }

    private static Predicate<String> notMatchedByAny(Set<Pattern> patterns) {
        return message -> {
            String normalizedMessage = message.replaceAll("\r*\n", " ");
            return patterns.stream().noneMatch(pattern -> pattern.matcher(normalizedMessage).matches());
        };
    }

    private static Set<Pattern> readPatternsFrom(String fileNameInClassPath) {
        URL ignorePatternsResource = ClassLoaders.getCurrentClassLoader(ArchRule.Assertions.class).getResource(fileNameInClassPath);
        if (ignorePatternsResource == null) {
            return Collections.emptySet();
        }
        try {
            return EvaluationResult.readPatternsFrom(ignorePatternsResource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<Pattern> readPatternsFrom(URL ignorePatternsResource) throws IOException {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String line : Resources.readLines(ignorePatternsResource, StandardCharsets.UTF_8)) {
            if (line.startsWith(COMMENT_LINE_PREFIX)) continue;
            result.add(Pattern.compile(line));
        }
        return result.build();
    }

    private static class FilteredEvent
    implements ConditionEvent {
        private final ConditionEvent delegate;
        private final Predicate<String> linePredicate;
        private final List<String> filteredDescriptionLines;

        private FilteredEvent(ConditionEvent delegate, Predicate<String> linePredicate) {
            this.delegate = delegate;
            this.linePredicate = linePredicate;
            this.filteredDescriptionLines = delegate.getDescriptionLines().stream().filter(linePredicate).collect(Collectors.toList());
        }

        @Override
        public boolean isViolation() {
            return this.delegate.isViolation() && !this.getDescriptionLines().isEmpty();
        }

        @Override
        public ConditionEvent invert() {
            return new FilteredEvent(this.delegate.invert(), this.linePredicate);
        }

        @Override
        public List<String> getDescriptionLines() {
            return this.filteredDescriptionLines;
        }

        @Override
        public void handleWith(ConditionEvent.Handler handler) {
            this.delegate.handleWith(new FilteredHandler(handler, this.linePredicate));
        }
    }

    private static class FilteredHandler
    implements ConditionEvent.Handler {
        private final ConditionEvent.Handler delegate;
        private final Predicate<String> linePredicate;

        private FilteredHandler(ConditionEvent.Handler delegate, Predicate<String> linePredicate) {
            this.delegate = delegate;
            this.linePredicate = linePredicate;
        }

        @Override
        public void handle(Collection<?> correspondingObjects, String message) {
            if (this.linePredicate.test(message)) {
                this.delegate.handle(correspondingObjects, message);
            }
        }
    }
}

