/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class SetAIMessage
extends AttributeMessage {
    public static final String TAG = "setAI";
    private static final String AI_TAG = "ai";
    private static final String PLAYER_TAG = "player";

    public SetAIMessage(Player player, boolean ai) {
        super(TAG, PLAYER_TAG, player.getId(), AI_TAG, String.valueOf(ai));
    }

    public SetAIMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG, AI_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        Player player = this.getPlayer(freeColServer.getGame());
        boolean ai = this.getAI();
        if (player == null) {
            return;
        }
        aiPlayer.setAIHandler(player, ai);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Player player = this.getPlayer(freeColClient.getGame());
        boolean ai = this.getAI();
        if (player == null) {
            return;
        }
        this.igc(freeColClient).setAIHandler(player, ai);
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }

    public boolean getAI() {
        return this.getBooleanAttribute(AI_TAG, Boolean.FALSE);
    }
}

