-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  CURRENT_DATABASE()::INFORMATION_SCHEMA.SQL_IDENTIFIER AS CONSTRAINT_CATALOG,
  CONSTRAINTS.CONSTRAINT_SCHEMA AS CONSTRAINT_SCHEMA,
  CONSTRAINTS.CONSTRAINT_NAME,
  CURRENT_DATABASE()::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_CATALOG,
  CONSTRAINTS.TABLE_SCHEMA AS TABLE_SCHEMA,
  CONSTRAINTS.TABLE_NAME,
  COLUMNS.COLUMN_NAME,
  COLUMNS.ORDINAL_POSITION,
  CONSTRAINTS.CONSTRAINT_TYPE,
  CONSTRAINTS.ENFORCED
FROM
  INFORMATION_SCHEMA.TABLE_CONSTRAINTS CONSTRAINTS
  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE COLUMNS
    ON
    COLUMNS.CONSTRAINT_CATALOG = CONSTRAINTS.CONSTRAINT_CATALOG
    AND COLUMNS.CONSTRAINT_SCHEMA = CONSTRAINTS.CONSTRAINT_SCHEMA
    AND COLUMNS.CONSTRAINT_NAME = CONSTRAINTS.CONSTRAINT_NAME
    AND COLUMNS.TABLE_SCHEMA = CONSTRAINTS.TABLE_SCHEMA
    AND COLUMNS.TABLE_NAME = CONSTRAINTS.TABLE_NAME
