-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  CURRENT_DATABASE()::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_CATALOG,
  NAMESPACES.NSPNAME::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_SCHEMA,
  TABLES.RELNAME::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_NAME,
  TABLES.RELTUPLES::BIGINT AS COUNT,
  TABLES.RELPAGES::BIGINT AS PAGES
FROM
  PG_CATALOG.PG_CLASS TABLES
  INNER JOIN PG_CATALOG.PG_NAMESPACE NAMESPACES
    ON TABLES.RELNAMESPACE = NAMESPACES.OID
WHERE
  NAMESPACES.NSPNAME NOT IN ('pg_catalog', 'information_schema')
  AND NAMESPACES.NSPNAME !~ '^pg_toast'
  AND TABLES.RELKIND IN ('r', 'v')
