/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.Utility;

abstract class AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(AbstractRetriever.class.getName());
    final MutableCatalog catalog;
    private final SchemaCrawlerOptions options;
    private final RetrieverConnection retrieverConnection;

    AbstractRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        this.retrieverConnection = Objects.requireNonNull(retrieverConnection, "No retriever connection provided");
        this.catalog = catalog;
        this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
    }

    final boolean belongsToSchema(DatabaseObject dbObject, String catalogName, String schemaName) {
        if (dbObject == null) {
            return false;
        }
        boolean supportsCatalogs = this.retrieverConnection.isSupportsCatalogs();
        boolean belongsToCatalog = true;
        boolean belongsToSchema = true;
        if (supportsCatalogs) {
            String dbObjectCatalogName = dbObject.getSchema().getCatalogName();
            if (catalogName != null && !catalogName.equals(dbObjectCatalogName)) {
                belongsToCatalog = false;
            }
        }
        String dbObjectSchemaName = dbObject.getSchema().getName();
        if (schemaName != null && !schemaName.equals(dbObjectSchemaName)) {
            belongsToSchema = false;
        }
        return belongsToCatalog && belongsToSchema;
    }

    final NamedObjectList<SchemaReference> getAllSchemas() {
        return this.catalog.getAllSchemas();
    }

    final Map<String, InclusionRule> getLimitMap() {
        HashMap<String, InclusionRule> limitMap = new HashMap<String, InclusionRule>();
        limitMap.put("schema-inclusion-rule", this.options.getLimitOptions().get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion));
        limitMap.put("table-inclusion-rule", this.options.getLimitOptions().get(DatabaseObjectRuleForInclusion.ruleForTableInclusion));
        return limitMap;
    }

    final RetrieverConnection getRetrieverConnection() {
        return this.retrieverConnection;
    }

    final void logPossiblyUnsupportedSQLFeature(Supplier<String> message, SQLException e) {
        if ("HYC00".equalsIgnoreCase(e.getSQLState()) || "HY000".equalsIgnoreCase(e.getSQLState()) || e instanceof SQLFeatureNotSupportedException) {
            this.logSQLFeatureNotSupported(message, e);
        } else {
            LOGGER.log(Level.WARNING, e, message);
        }
    }

    final void logSQLFeatureNotSupported(Supplier<String> message, Throwable e) {
        LOGGER.log(Level.WARNING, message);
        LOGGER.log(Level.FINE, e, message);
    }

    final MutableColumnDataType lookupOrCreateColumnDataType(DataTypeType type, Schema schema, int javaSqlTypeInt, String databaseSpecificTypeName) {
        return this.lookupOrCreateColumnDataType(type, schema, javaSqlTypeInt, databaseSpecificTypeName, null);
    }

    final MutableColumnDataType lookupOrCreateColumnDataType(DataTypeType type, Schema schema, int javaSqlTypeInt, String databaseSpecificTypeName, String mappedClassName) {
        MutableColumnDataType columnDataType = this.catalog.lookupColumnDataType(schema, databaseSpecificTypeName).orElse(this.catalog.lookupSystemColumnDataType(databaseSpecificTypeName).orElse(null));
        if (columnDataType == null) {
            columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName, type);
            JavaSqlType javaSqlType = this.retrieverConnection.getJavaSqlTypes().valueOf(javaSqlTypeInt);
            columnDataType.setJavaSqlType(javaSqlType);
            if (Utility.isBlank(mappedClassName)) {
                TypeMap typeMap = this.retrieverConnection.getTypeMap();
                Object mappedClass = typeMap.containsKey(databaseSpecificTypeName) ? typeMap.get(databaseSpecificTypeName) : typeMap.get(javaSqlType.getName());
                columnDataType.setTypeMappedClass((Class<?>)mappedClass);
            } else {
                columnDataType.setTypeMappedClass(mappedClassName);
            }
            columnDataType.withQuoting(this.getRetrieverConnection().getIdentifiers());
            this.catalog.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    final Optional<MutableRoutine> lookupRoutine(String catalogName, String schemaName, String routineName, String specificName) {
        return this.catalog.lookupRoutine(new NamedObjectKey(catalogName, schemaName, routineName, specificName));
    }

    final Optional<MutableTable> lookupTable(String catalogName, String schemaName, String tableName) {
        return this.catalog.lookupTable(new NamedObjectKey(catalogName, schemaName, tableName));
    }

    final String normalizeCatalogName(String name) {
        if (this.retrieverConnection.isSupportsCatalogs()) {
            return name;
        }
        return null;
    }

    final String normalizeSchemaName(String name) {
        if (this.retrieverConnection.isSupportsSchemas()) {
            return name;
        }
        return null;
    }
}

