/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.util.Map;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;

public class DatabaseServerHostConnectionOptions
implements DatabaseConnectionOptions {
    private final String database;
    private final String databaseSystemIdentifier;
    private final String host;
    private final Integer port;
    private final Map<String, String> urlx;

    public DatabaseServerHostConnectionOptions(String databaseSystemIdentifier, String host, Integer port, String database, Map<String, String> urlx) {
        this.databaseSystemIdentifier = databaseSystemIdentifier;
        this.host = host;
        this.port = port;
        this.database = database;
        this.urlx = urlx;
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public DatabaseConnector getDatabaseConnector() {
        DatabaseConnectorRegistry databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        return databaseConnectorRegistry.findDatabaseConnectorFromDatabaseSystemIdentifier(this.databaseSystemIdentifier);
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Map<String, String> getUrlx() {
        return this.urlx;
    }
}

