/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.base;

import schemacrawler.schema.CrawlInfo;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.text.options.BaseTextOptions;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;

public abstract class BaseTabularFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected BaseTabularFormatter(SchemaTextDetailType schemaTextDetailType, O options, OutputOptions outputOptions, Identifiers identifiers) {
        super(schemaTextDetailType, options, outputOptions, identifiers);
    }

    @Override
    public void begin() {
        this.formattingHelper.writeDocumentStart();
    }

    @Override
    public void end() {
        this.formattingHelper.writeDocumentEnd();
        super.end();
    }

    @Override
    public final void handleHeader(CrawlInfo crawlInfo) {
        if (crawlInfo == null) {
            return;
        }
        String title = this.outputOptions.getTitle();
        if (!Utility.isBlank((CharSequence)title)) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.title, title);
        }
        if (this.options.isNoInfo() || this.options.isNoSchemaCrawlerInfo() && !this.options.isShowDatabaseInfo() && !this.options.isShowJdbcDriverInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
        this.formattingHelper.writeObjectStart();
        if (!this.options.isNoSchemaCrawlerInfo()) {
            this.formattingHelper.writeNameValueRow("generated by", crawlInfo.getSchemaCrawlerVersion().toString(), Alignment.inherit);
            this.formattingHelper.writeNameValueRow("generated on", crawlInfo.getCrawlTimestamp(), Alignment.inherit);
        }
        if (this.options.isShowDatabaseInfo()) {
            this.formattingHelper.writeNameValueRow("database version", crawlInfo.getDatabaseVersion().toString(), Alignment.inherit);
        }
        if (this.options.isShowJdbcDriverInfo()) {
            this.formattingHelper.writeNameValueRow("driver version", crawlInfo.getJdbcDriverVersion().toString(), Alignment.inherit);
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleHeaderEnd() {
    }

    @Override
    public void handleHeaderStart() {
    }

    protected final boolean printVerboseDatabaseInfo() {
        return !this.options.isNoInfo() && this.schemaTextDetailType == SchemaTextDetailType.details;
    }
}

