/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.StringUtil;

public class HsqlDateTime {
    public static final Locale defaultLocale = Locale.UK;
    private static final Calendar tempCalDefault = new GregorianCalendar();
    private static final Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd", defaultLocale);
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat sdfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", defaultLocale);
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Date sysDate = new Date();
    private static final IntValueHashMap<String> shortNameToIntervalTypeCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date date = sdfd.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long l) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date date = sdfts.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l, int n, int n2) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l * 1000L);
            String string = sdfts.format(sysDate);
            if (n2 > 0) {
                string = string + '.' + StringUtil.toZeroPaddedString(n, 9, n2);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l);
            return sdfts.format(sysDate);
        }
    }

    private static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long l) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            Calendar calendar3 = calendar;
            synchronized (calendar3) {
                calendar.clear();
                tempCalGMT.setTimeInMillis(l);
                calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
                return calendar.getTimeInMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, Calendar calendar2, long l) {
        Calendar calendar3 = calendar2;
        synchronized (calendar3) {
            Calendar calendar4 = calendar;
            synchronized (calendar4) {
                calendar2.clear();
                calendar.setTimeInMillis(l);
                calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                return calendar2.getTimeInMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertSecondsFromCalendar(Calendar calendar, Calendar calendar2, long l) {
        Calendar calendar3 = calendar2;
        synchronized (calendar3) {
            Calendar calendar4 = calendar;
            synchronized (calendar4) {
                calendar2.clear();
                calendar.setTimeInMillis(l * 1000L);
                calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                return calendar2.getTimeInMillis() / 1000L;
            }
        }
    }

    public static long getNormalisedTime(long l) {
        return HsqlDateTime.getNormalisedTime(tempCalGMT, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            HsqlDateTime.resetToTime(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static long getNormalisedDate(long l) {
        return HsqlDateTime.getNormalisedDate(tempCalGMT, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            HsqlDateTime.resetToDate(calendar);
            return calendar.getTimeInMillis();
        }
    }

    public static int getZoneSeconds() {
        return HsqlDateTime.getZoneSeconds(tempCalDefault);
    }

    public static int getZoneSeconds(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTruncatedPart(Calendar calendar, long l, int n) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            switch (n) {
                case 136: {
                    int n2 = calendar.get(7);
                    if (n2 == 1) {
                        n2 = 8;
                    }
                    calendar.add(6, 2 - n2);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                case 126: {
                    int n3 = calendar.get(7);
                    calendar.add(6, 1 - n3);
                    HsqlDateTime.resetToDate(calendar);
                    break;
                }
                case 127: {
                    int n4 = calendar.get(2);
                    n4 = n4 / 3 * 3;
                    HsqlDateTime.zeroFromPart(calendar, 102);
                    calendar.set(2, n4);
                    break;
                }
                default: {
                    HsqlDateTime.zeroFromPart(calendar, n);
                }
            }
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRoundedPart(Calendar calendar, long l, int n) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            switch (n) {
                case 101: {
                    if (calendar.get(2) <= 6) break;
                    calendar.add(1, 1);
                    break;
                }
                case 102: {
                    if (calendar.get(5) <= 15) break;
                    calendar.add(2, 1);
                    break;
                }
                case 103: {
                    if (calendar.get(11) <= 11) break;
                    calendar.add(5, 1);
                    break;
                }
                case 104: {
                    if (calendar.get(12) <= 29) break;
                    calendar.add(11, 1);
                    break;
                }
                case 105: {
                    if (calendar.get(13) <= 29) break;
                    calendar.add(12, 1);
                    break;
                }
                case 106: {
                    if (calendar.get(14) <= 499) break;
                    calendar.add(13, 1);
                    break;
                }
                case 126: {
                    int n2 = calendar.get(6);
                    int n3 = calendar.get(1);
                    int n4 = calendar.get(3);
                    int n5 = calendar.get(7);
                    calendar.clear();
                    calendar.set(1, n3);
                    if (n5 > 3) {
                        ++n4;
                    }
                    if (n4 == 1 && (n2 > 356 || n2 < 7)) {
                        calendar.set(6, n2);
                        while (true) {
                            if (calendar.get(7) == 1) {
                                return calendar.getTimeInMillis();
                            }
                            calendar.add(6, -1);
                        }
                    }
                    calendar.set(3, n4);
                    return calendar.getTimeInMillis();
                }
            }
            HsqlDateTime.zeroFromPart(calendar, n);
            return calendar.getTimeInMillis();
        }
    }

    public static void zeroFromPart(Calendar calendar, int n) {
        switch (n) {
            case 101: {
                calendar.set(2, 0);
            }
            case 102: {
                calendar.set(5, 1);
            }
            case 103: {
                calendar.set(11, 0);
            }
            case 104: {
                calendar.set(12, 0);
            }
            case 105: {
                calendar.set(13, 0);
            }
            case 106: {
                calendar.set(14, 0);
            }
        }
    }

    public static int toStandardIntervalPart(String string) {
        return shortNameToIntervalTypeCode.get((Object)string, -1);
    }

    static {
        TimeZone.getDefault();
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfd.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfts.setLenient(false);
        shortNameToIntervalTypeCode = new IntValueHashMap();
        shortNameToIntervalTypeCode.put("YYYY", 101);
        shortNameToIntervalTypeCode.put("YY", 101);
        shortNameToIntervalTypeCode.put("MONTH", 102);
        shortNameToIntervalTypeCode.put("MON", 102);
        shortNameToIntervalTypeCode.put("MM", 102);
        shortNameToIntervalTypeCode.put("WW", 126);
        shortNameToIntervalTypeCode.put("IW", 136);
        shortNameToIntervalTypeCode.put("DDD", 103);
        shortNameToIntervalTypeCode.put("DD", 103);
        shortNameToIntervalTypeCode.put("HH24", 104);
        shortNameToIntervalTypeCode.put("HH12", 104);
        shortNameToIntervalTypeCode.put("HH", 104);
        shortNameToIntervalTypeCode.put("MI", 105);
        shortNameToIntervalTypeCode.put("SS", 106);
    }

    public static class SystemTimeString {
        private Date date = new Date();
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public SystemTimeString() {
            this.dateFormat.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
            this.dateFormat.setLenient(false);
        }

        public synchronized String getTimestampString() {
            this.date.setTime(System.currentTimeMillis());
            return this.dateFormat.format(this.date);
        }
    }
}

