/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public final class LayerConstraintPreprocessor
implements ILayoutProcessor<LGraph> {
    private static final IProperty<HiddenNodeConnections> HIDDEN_NODE_CONNECTIONS = new Property<HiddenNodeConnections>("separateLayerConnections", HiddenNodeConnections.NONE);

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Layer constraint preprocessing", 1.0f);
        ArrayList<LNode> hiddenNodes = new ArrayList<LNode>();
        ListIterator<LNode> nodeIterator = layeredGraph.getLayerlessNodes().listIterator();
        while (nodeIterator.hasNext()) {
            LNode lNode = nodeIterator.next();
            if (!this.isRelevantNode(lNode)) continue;
            this.hide(lNode);
            hiddenNodes.add(lNode);
            nodeIterator.remove();
        }
        if (!hiddenNodes.isEmpty()) {
            layeredGraph.setProperty(InternalProperties.HIDDEN_NODES, hiddenNodes);
        }
        monitor.done();
    }

    private boolean isRelevantNode(LNode lNode) {
        switch (lNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
            case FIRST_SEPARATE: 
            case LAST_SEPARATE: {
                return true;
            }
        }
        return false;
    }

    private void hide(LNode lNode) {
        this.ensureNoInacceptableEdges(lNode);
        for (LEdge lEdge : lNode.getConnectedEdges()) {
            this.hide(lNode, lEdge);
        }
    }

    private void hide(LNode lNode, LEdge lEdge) {
        LPort oppositePort;
        boolean isOutgoing = lEdge.getSource().getNode() == lNode;
        LPort lPort = oppositePort = isOutgoing ? lEdge.getTarget() : lEdge.getSource();
        if (isOutgoing) {
            lEdge.setTarget(null);
        } else {
            lEdge.setSource(null);
        }
        lEdge.setProperty(InternalProperties.ORIGINAL_OPPOSITE_PORT, oppositePort);
        this.updateOppositeNodeLayerConstraints(lNode, oppositePort.getNode());
    }

    private void updateOppositeNodeLayerConstraints(LNode hiddenNode, LNode oppositeNode) {
        if (oppositeNode.hasProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
            return;
        }
        HiddenNodeConnections connections = oppositeNode.getProperty(HIDDEN_NODE_CONNECTIONS).combine(hiddenNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT));
        oppositeNode.setProperty(HIDDEN_NODE_CONNECTIONS, (Object)connections);
        if (oppositeNode.getConnectedEdges().iterator().hasNext()) {
            return;
        }
        switch (connections) {
            case FIRST_SEPARATE: {
                oppositeNode.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST);
                break;
            }
            case LAST_SEPARATE: {
                oppositeNode.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.LAST);
            }
        }
    }

    private void ensureNoInacceptableEdges(LNode lNode) {
        block3: {
            LayerConstraint layerConstraint;
            block2: {
                layerConstraint = lNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
                if (layerConstraint != LayerConstraint.FIRST_SEPARATE) break block2;
                for (LEdge inEdge : lNode.getIncomingEdges()) {
                    if (this.isAcceptableIncidentEdge(inEdge)) continue;
                    throw new UnsupportedConfigurationException("Node '" + lNode.getDesignation() + "' has its layer constraint set to FIRST_SEPARATE, but has at least one incoming edge. " + "FIRST_SEPARATE nodes must not have incoming edges.");
                }
                break block3;
            }
            if (layerConstraint != LayerConstraint.LAST_SEPARATE) break block3;
            for (LEdge outEdge : lNode.getOutgoingEdges()) {
                if (this.isAcceptableIncidentEdge(outEdge)) continue;
                throw new UnsupportedConfigurationException("Node '" + lNode.getDesignation() + "' has its layer constraint set to LAST_SEPARATE, but has at least one outgoing edge. " + "LAST_SEPARATE nodes must not have outgoing edges.");
            }
        }
    }

    private boolean isAcceptableIncidentEdge(LEdge edge) {
        LNode sourceNode = edge.getSource().getNode();
        LNode targetNode = edge.getTarget().getNode();
        return sourceNode.getType() == LNode.NodeType.EXTERNAL_PORT && targetNode.getType() == LNode.NodeType.EXTERNAL_PORT;
    }

    private static enum HiddenNodeConnections {
        NONE,
        FIRST_SEPARATE,
        LAST_SEPARATE,
        BOTH;


        private HiddenNodeConnections combine(LayerConstraint layerConstraint) {
            switch (this) {
                case NONE: {
                    return layerConstraint == LayerConstraint.FIRST_SEPARATE ? FIRST_SEPARATE : LAST_SEPARATE;
                }
                case FIRST_SEPARATE: {
                    return layerConstraint == LayerConstraint.FIRST_SEPARATE ? FIRST_SEPARATE : BOTH;
                }
                case LAST_SEPARATE: {
                    return layerConstraint == LayerConstraint.FIRST_SEPARATE ? BOTH : LAST_SEPARATE;
                }
            }
            return BOTH;
        }
    }
}

