/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.StsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssumeRootResponse
extends StsResponse
implements ToCopyableBuilder<Builder, AssumeRootResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(AssumeRootResponse.getter(AssumeRootResponse::credentials)).setter(AssumeRootResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<String> SOURCE_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIdentity").getter(AssumeRootResponse.getter(AssumeRootResponse::sourceIdentity)).setter(AssumeRootResponse.setter(Builder::sourceIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, SOURCE_IDENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssumeRootResponse.memberNameToFieldInitializer();
    private final Credentials credentials;
    private final String sourceIdentity;

    private AssumeRootResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.sourceIdentity = builder.sourceIdentity;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final String sourceIdentity() {
        return this.sourceIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRootResponse)) {
            return false;
        }
        AssumeRootResponse other = (AssumeRootResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.sourceIdentity(), other.sourceIdentity());
    }

    public final String toString() {
        return ToString.builder((String)"AssumeRootResponse").add("Credentials", (Object)this.credentials()).add("SourceIdentity", (Object)this.sourceIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "SourceIdentity": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("SourceIdentity", SOURCE_IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssumeRootResponse, T> g) {
        return obj -> g.apply((AssumeRootResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StsResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private String sourceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRootResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.sourceIdentity(model.sourceIdentity);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getSourceIdentity() {
            return this.sourceIdentity;
        }

        public final void setSourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
        }

        @Override
        public final Builder sourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
            return this;
        }

        @Override
        public AssumeRootResponse build() {
            return new AssumeRootResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssumeRootResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder sourceIdentity(String var1);
    }
}

