/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.action.mcpserver.McpToolsHelper;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.MLIndex;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.mcpserver.action.MLMcpToolsRemoveOnNodesAction;
import org.opensearch.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import org.opensearch.ml.common.transport.mcpserver.requests.message.MLMcpMessageRequest;
import org.opensearch.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import org.opensearch.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodesRequest;
import org.opensearch.ml.common.transport.mcpserver.responses.remove.MLMcpToolsRemoveNodesResponse;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportMcpToolsRemoveAction
extends HandledTransportAction<ActionRequest, MLMcpToolsRemoveNodesResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpToolsRemoveAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final McpToolsHelper mcpToolsHelper;

    @Inject
    public TransportMcpToolsRemoveAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, McpToolsHelper mcpToolsHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/mcp_tools/remove", transportService, actionFilters, MLMcpMessageRequest::new);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mcpToolsHelper = mcpToolsHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLMcpToolsRemoveNodesResponse> listener) {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            listener.onFailure((Exception)new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        MLMcpToolsRemoveNodesRequest removeToolsOnNodesRequest = (MLMcpToolsRemoveNodesRequest)request;
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener searchResultListener = ActionListener.wrap(searchResult -> {
                if (!searchResult.isEmpty()) {
                    List<String> foundTools = searchResult.stream().map(McpToolBaseInput::getName).toList();
                    foundTools.forEach(x -> removeToolsOnNodesRequest.getMcpTools().remove(x));
                    if (!removeToolsOnNodesRequest.getMcpTools().isEmpty()) {
                        String exceptionMessage = String.format(Locale.ROOT, "Unable to remove tools as these tools: %s are not found in system index", removeToolsOnNodesRequest.getMcpTools());
                        log.info(exceptionMessage);
                        restoreListener.onFailure((Exception)new OpenSearchException(exceptionMessage, new Object[0]));
                    } else {
                        this.bulkDeleteMcpTools(removeToolsOnNodesRequest, foundTools, (ActionListener<MLMcpToolsRemoveNodesResponse>)restoreListener);
                    }
                } else {
                    String exceptionMessage = "Unable to remove tools as no tool in the request found in system index";
                    log.warn(exceptionMessage);
                    restoreListener.onFailure((Exception)new OpenSearchException(exceptionMessage, new Object[0]));
                }
            }, e -> {
                log.error("Failed to search mcp tools index", (Throwable)e);
                restoreListener.onFailure(e);
            });
            this.mcpToolsHelper.searchToolsWithVersion(removeToolsOnNodesRequest.getMcpTools(), (ActionListener<List<McpToolRegisterInput>>)searchResultListener);
        }
        catch (Exception e2) {
            log.error("Failed to remove mcp tools caused by system internal error", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void bulkDeleteMcpTools(MLMcpToolsRemoveNodesRequest removeToolsOnNodesRequest, List<String> foundTools, ActionListener<MLMcpToolsRemoveNodesResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener bulkResultListener = ActionListener.wrap(bulkResponse -> {
                if (!bulkResponse.hasFailures()) {
                    this.removeMcpToolsInMemory(removeToolsOnNodesRequest, new StringBuilder(), foundTools, (ActionListener<MLMcpToolsRemoveNodesResponse>)restoreListener);
                } else {
                    StringBuilder errMsgBuilder = new StringBuilder();
                    ArrayList<String> removeSucceedTools = new ArrayList<String>();
                    Arrays.stream(bulkResponse.getItems()).forEach(x -> {
                        if (x.isFailed()) {
                            errMsgBuilder.append(String.format(Locale.ROOT, "Failed to remove tool: %s from index with error: %s", x.getId(), x.getFailure().getMessage()));
                            errMsgBuilder.append("\n");
                        } else {
                            removeSucceedTools.add(x.getId());
                        }
                    });
                    removeToolsOnNodesRequest.setMcpTools(removeSucceedTools);
                    this.removeMcpToolsInMemory(removeToolsOnNodesRequest, errMsgBuilder, removeSucceedTools, (ActionListener<MLMcpToolsRemoveNodesResponse>)restoreListener);
                }
            }, e -> {
                log.error("Failed to delete MCP tools in index", (Throwable)e);
                restoreListener.onFailure(e);
            });
            BulkRequest bulkRequest = new BulkRequest();
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (String name : foundTools) {
                DeleteRequest deleteRequest = new DeleteRequest(MLIndex.MCP_TOOLS.getIndexName(), name);
                bulkRequest.add(deleteRequest);
            }
            this.client.bulk(bulkRequest, bulkResultListener);
        }
        catch (Exception e2) {
            log.error("Failed to remove mcp tools", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void removeMcpToolsInMemory(MLMcpToolsRemoveNodesRequest removeToolsOnNodesRequest, StringBuilder errMsgBuilder, List<String> removeSucceedTools, ActionListener<MLMcpToolsRemoveNodesResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener removeFromMemoryResultListener = ActionListener.wrap(r -> {
                if (r.failures() != null && !r.failures().isEmpty()) {
                    r.failures().forEach(x -> {
                        errMsgBuilder.append(String.format(Locale.ROOT, "Tools: %s are removed successfully in index but failed to remove from mcp server in memory with error: %s", removeSucceedTools, x.getRootCause().getMessage()));
                        errMsgBuilder.append("\n");
                    });
                    errMsgBuilder.deleteCharAt(errMsgBuilder.length() - 1);
                    log.error(errMsgBuilder.toString());
                    restoreListener.onFailure((Exception)new OpenSearchException(errMsgBuilder.toString(), new Object[0]));
                } else if (errMsgBuilder.isEmpty()) {
                    restoreListener.onResponse(r);
                } else {
                    restoreListener.onFailure((Exception)new OpenSearchException(errMsgBuilder.deleteCharAt(errMsgBuilder.length() - 1).toString(), new Object[0]));
                }
            }, e -> {
                errMsgBuilder.append(String.format(Locale.ROOT, "Tools are removed successfully in index but failed to remove from mcp server memory with error: %s", e.getMessage()));
                log.error(errMsgBuilder.toString(), (Throwable)e);
                restoreListener.onFailure((Exception)new OpenSearchException(errMsgBuilder.toString(), new Object[0]));
            });
            removeToolsOnNodesRequest.setMcpTools(removeSucceedTools);
            this.client.execute((ActionType)MLMcpToolsRemoveOnNodesAction.INSTANCE, (ActionRequest)removeToolsOnNodesRequest, removeFromMemoryResultListener);
        }
        catch (Exception e2) {
            String errMsg = String.format(Locale.ROOT, "Failed to remove mcp tools on nodes memory with error: %s", e2.getMessage());
            log.error(errMsg, (Throwable)e2);
            listener.onFailure((Exception)new OpenSearchException(errMsg, new Object[0]));
        }
    }
}

