/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN990Codec;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.opensearch.common.UUIDs;
import org.opensearch.knn.index.codec.KNN990Codec.QuantizationConfigKNNCollector;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.codec.util.NativeMemoryCacheKeyHelper;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.quantizationservice.QuantizationService;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateCacheManager;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateReadConfig;

public class NativeEngines990KnnVectorsReader
extends KnnVectorsReader {
    private final FlatVectorsReader flatVectorsReader;
    private Map<String, String> quantizationStateCacheKeyPerField;
    private SegmentReadState segmentReadState;
    private final List<String> cacheKeys;

    public NativeEngines990KnnVectorsReader(SegmentReadState state, FlatVectorsReader flatVectorsReader) {
        this.flatVectorsReader = flatVectorsReader;
        this.segmentReadState = state;
        this.cacheKeys = NativeEngines990KnnVectorsReader.getVectorCacheKeysFromSegmentReaderState(state);
        this.loadCacheKeyMap();
    }

    public void checkIntegrity() throws IOException {
        this.flatVectorsReader.checkIntegrity();
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getFloatVectorValues(field);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getByteVectorValues(field);
    }

    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        if (knnCollector instanceof QuantizationConfigKNNCollector) {
            String cacheKey = this.quantizationStateCacheKeyPerField.get(field);
            FieldInfo fieldInfo = this.segmentReadState.fieldInfos.fieldInfo(field);
            QuantizationState quantizationState = QuantizationStateCacheManager.getInstance().getQuantizationState(new QuantizationStateReadConfig(this.segmentReadState, QuantizationService.getInstance().getQuantizationParams(fieldInfo), field, cacheKey));
            ((QuantizationConfigKNNCollector)knnCollector).setQuantizationState(quantizationState);
            return;
        }
        throw new UnsupportedOperationException("Search functionality using codec is not supported with Native Engine Reader");
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException("Search functionality using codec is not supported with Native Engine Reader");
    }

    public void close() throws IOException {
        NativeMemoryCacheManager nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
        this.cacheKeys.forEach(nativeMemoryCacheManager::invalidate);
        IOUtils.close((Closeable[])new Closeable[]{this.flatVectorsReader});
        if (this.quantizationStateCacheKeyPerField != null) {
            QuantizationStateCacheManager quantizationStateCacheManager = QuantizationStateCacheManager.getInstance();
            for (String cacheKey : this.quantizationStateCacheKeyPerField.values()) {
                quantizationStateCacheManager.evict(cacheKey);
            }
        }
    }

    public long ramBytesUsed() {
        return this.flatVectorsReader.ramBytesUsed();
    }

    private void loadCacheKeyMap() {
        this.quantizationStateCacheKeyPerField = new HashMap<String, String>();
        for (FieldInfo fieldInfo : this.segmentReadState.fieldInfos) {
            String cacheKey = UUIDs.base64UUID();
            this.quantizationStateCacheKeyPerField.put(fieldInfo.getName(), cacheKey);
        }
    }

    private static List<String> getVectorCacheKeysFromSegmentReaderState(SegmentReadState segmentReadState) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        for (FieldInfo field : segmentReadState.fieldInfos) {
            String vectorIndexFileName = KNNCodecUtil.getNativeEngineFileFromFieldInfo(field, segmentReadState.segmentInfo);
            if (vectorIndexFileName == null) continue;
            String cacheKey = NativeMemoryCacheKeyHelper.constructCacheKey(vectorIndexFileName, segmentReadState.segmentInfo);
            cacheKeys.add(cacheKey);
        }
        return cacheKeys;
    }
}

