/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SSEType;
import software.amazon.awssdk.services.ec2.model.SnapshotState;
import software.amazon.awssdk.services.ec2.model.StorageTier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransferType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateSnapshotResponse> {
    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAlias").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::ownerAlias)).setter(CreateSnapshotResponse.setter(Builder::ownerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias").unmarshallLocationName("ownerAlias").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::outpostArn)).setter(CreateSnapshotResponse.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::tags)).setter(CreateSnapshotResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageTier").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::storageTierAsString)).setter(CreateSnapshotResponse.setter(Builder::storageTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTier").unmarshallLocationName("storageTier").build()}).build();
    private static final SdkField<Instant> RESTORE_EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RestoreExpiryTime").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::restoreExpiryTime)).setter(CreateSnapshotResponse.setter(Builder::restoreExpiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreExpiryTime").unmarshallLocationName("restoreExpiryTime").build()}).build();
    private static final SdkField<String> SSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SseType").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::sseTypeAsString)).setter(CreateSnapshotResponse.setter(Builder::sseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType").unmarshallLocationName("sseType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::availabilityZone)).setter(CreateSnapshotResponse.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> TRANSFER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferType").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::transferTypeAsString)).setter(CreateSnapshotResponse.setter(Builder::transferType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferType").unmarshallLocationName("transferType").build()}).build();
    private static final SdkField<Integer> COMPLETION_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CompletionDurationMinutes").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::completionDurationMinutes)).setter(CreateSnapshotResponse.setter(Builder::completionDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDurationMinutes").unmarshallLocationName("completionDurationMinutes").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::completionTime)).setter(CreateSnapshotResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").unmarshallLocationName("completionTime").build()}).build();
    private static final SdkField<Long> FULL_SNAPSHOT_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FullSnapshotSizeInBytes").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::fullSnapshotSizeInBytes)).setter(CreateSnapshotResponse.setter(Builder::fullSnapshotSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullSnapshotSizeInBytes").unmarshallLocationName("fullSnapshotSizeInBytes").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::snapshotId)).setter(CreateSnapshotResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::volumeId)).setter(CreateSnapshotResponse.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::stateAsString)).setter(CreateSnapshotResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::stateMessage)).setter(CreateSnapshotResponse.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::startTime)).setter(CreateSnapshotResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Progress").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::progress)).setter(CreateSnapshotResponse.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::ownerId)).setter(CreateSnapshotResponse.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::description)).setter(CreateSnapshotResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSize").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::volumeSize)).setter(CreateSnapshotResponse.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").unmarshallLocationName("volumeSize").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::encrypted)).setter(CreateSnapshotResponse.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::kmsKeyId)).setter(CreateSnapshotResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("kmsKeyId").build()}).build();
    private static final SdkField<String> DATA_ENCRYPTION_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataEncryptionKeyId").getter(CreateSnapshotResponse.getter(CreateSnapshotResponse::dataEncryptionKeyId)).setter(CreateSnapshotResponse.setter(Builder::dataEncryptionKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEncryptionKeyId").unmarshallLocationName("dataEncryptionKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ALIAS_FIELD, OUTPOST_ARN_FIELD, TAGS_FIELD, STORAGE_TIER_FIELD, RESTORE_EXPIRY_TIME_FIELD, SSE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, TRANSFER_TYPE_FIELD, COMPLETION_DURATION_MINUTES_FIELD, COMPLETION_TIME_FIELD, FULL_SNAPSHOT_SIZE_IN_BYTES_FIELD, SNAPSHOT_ID_FIELD, VOLUME_ID_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, START_TIME_FIELD, PROGRESS_FIELD, OWNER_ID_FIELD, DESCRIPTION_FIELD, VOLUME_SIZE_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DATA_ENCRYPTION_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSnapshotResponse.memberNameToFieldInitializer();
    private final String ownerAlias;
    private final String outpostArn;
    private final List<Tag> tags;
    private final String storageTier;
    private final Instant restoreExpiryTime;
    private final String sseType;
    private final String availabilityZone;
    private final String transferType;
    private final Integer completionDurationMinutes;
    private final Instant completionTime;
    private final Long fullSnapshotSizeInBytes;
    private final String snapshotId;
    private final String volumeId;
    private final String state;
    private final String stateMessage;
    private final Instant startTime;
    private final String progress;
    private final String ownerId;
    private final String description;
    private final Integer volumeSize;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String dataEncryptionKeyId;

    private CreateSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAlias = builder.ownerAlias;
        this.outpostArn = builder.outpostArn;
        this.tags = builder.tags;
        this.storageTier = builder.storageTier;
        this.restoreExpiryTime = builder.restoreExpiryTime;
        this.sseType = builder.sseType;
        this.availabilityZone = builder.availabilityZone;
        this.transferType = builder.transferType;
        this.completionDurationMinutes = builder.completionDurationMinutes;
        this.completionTime = builder.completionTime;
        this.fullSnapshotSizeInBytes = builder.fullSnapshotSizeInBytes;
        this.snapshotId = builder.snapshotId;
        this.volumeId = builder.volumeId;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.startTime = builder.startTime;
        this.progress = builder.progress;
        this.ownerId = builder.ownerId;
        this.description = builder.description;
        this.volumeSize = builder.volumeSize;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dataEncryptionKeyId = builder.dataEncryptionKeyId;
    }

    public final String ownerAlias() {
        return this.ownerAlias;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final StorageTier storageTier() {
        return StorageTier.fromValue(this.storageTier);
    }

    public final String storageTierAsString() {
        return this.storageTier;
    }

    public final Instant restoreExpiryTime() {
        return this.restoreExpiryTime;
    }

    public final SSEType sseType() {
        return SSEType.fromValue(this.sseType);
    }

    public final String sseTypeAsString() {
        return this.sseType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final TransferType transferType() {
        return TransferType.fromValue(this.transferType);
    }

    public final String transferTypeAsString() {
        return this.transferType;
    }

    public final Integer completionDurationMinutes() {
        return this.completionDurationMinutes;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Long fullSnapshotSizeInBytes() {
        return this.fullSnapshotSizeInBytes;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final SnapshotState state() {
        return SnapshotState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String progress() {
        return this.progress;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String description() {
        return this.description;
    }

    public final Integer volumeSize() {
        return this.volumeSize;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dataEncryptionKeyId() {
        return this.dataEncryptionKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreExpiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullSnapshotSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEncryptionKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotResponse)) {
            return false;
        }
        CreateSnapshotResponse other = (CreateSnapshotResponse)((Object)obj);
        return Objects.equals(this.ownerAlias(), other.ownerAlias()) && Objects.equals(this.outpostArn(), other.outpostArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageTierAsString(), other.storageTierAsString()) && Objects.equals(this.restoreExpiryTime(), other.restoreExpiryTime()) && Objects.equals(this.sseTypeAsString(), other.sseTypeAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.transferTypeAsString(), other.transferTypeAsString()) && Objects.equals(this.completionDurationMinutes(), other.completionDurationMinutes()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.fullSnapshotSizeInBytes(), other.fullSnapshotSizeInBytes()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dataEncryptionKeyId(), other.dataEncryptionKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotResponse").add("OwnerAlias", (Object)this.ownerAlias()).add("OutpostArn", (Object)this.outpostArn()).add("Tags", this.hasTags() ? this.tags() : null).add("StorageTier", (Object)this.storageTierAsString()).add("RestoreExpiryTime", (Object)this.restoreExpiryTime()).add("SseType", (Object)this.sseTypeAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("TransferType", (Object)this.transferTypeAsString()).add("CompletionDurationMinutes", (Object)this.completionDurationMinutes()).add("CompletionTime", (Object)this.completionTime()).add("FullSnapshotSizeInBytes", (Object)this.fullSnapshotSizeInBytes()).add("SnapshotId", (Object)this.snapshotId()).add("VolumeId", (Object)this.volumeId()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).add("StartTime", (Object)this.startTime()).add("Progress", (Object)this.progress()).add("OwnerId", (Object)this.ownerId()).add("Description", (Object)this.description()).add("VolumeSize", (Object)this.volumeSize()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DataEncryptionKeyId", (Object)this.dataEncryptionKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.ownerAlias()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StorageTier": {
                return Optional.ofNullable(clazz.cast(this.storageTierAsString()));
            }
            case "RestoreExpiryTime": {
                return Optional.ofNullable(clazz.cast(this.restoreExpiryTime()));
            }
            case "SseType": {
                return Optional.ofNullable(clazz.cast(this.sseTypeAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "TransferType": {
                return Optional.ofNullable(clazz.cast(this.transferTypeAsString()));
            }
            case "CompletionDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.completionDurationMinutes()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "FullSnapshotSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.fullSnapshotSizeInBytes()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DataEncryptionKeyId": {
                return Optional.ofNullable(clazz.cast(this.dataEncryptionKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerAlias", OWNER_ALIAS_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("StorageTier", STORAGE_TIER_FIELD);
        map.put("RestoreExpiryTime", RESTORE_EXPIRY_TIME_FIELD);
        map.put("SseType", SSE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("TransferType", TRANSFER_TYPE_FIELD);
        map.put("CompletionDurationMinutes", COMPLETION_DURATION_MINUTES_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("FullSnapshotSizeInBytes", FULL_SNAPSHOT_SIZE_IN_BYTES_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Status", STATE_FIELD);
        map.put("StatusMessage", STATE_MESSAGE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("DataEncryptionKeyId", DATA_ENCRYPTION_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotResponse, T> g) {
        return obj -> g.apply((CreateSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String ownerAlias;
        private String outpostArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String storageTier;
        private Instant restoreExpiryTime;
        private String sseType;
        private String availabilityZone;
        private String transferType;
        private Integer completionDurationMinutes;
        private Instant completionTime;
        private Long fullSnapshotSizeInBytes;
        private String snapshotId;
        private String volumeId;
        private String state;
        private String stateMessage;
        private Instant startTime;
        private String progress;
        private String ownerId;
        private String description;
        private Integer volumeSize;
        private Boolean encrypted;
        private String kmsKeyId;
        private String dataEncryptionKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotResponse model) {
            super(model);
            this.ownerAlias(model.ownerAlias);
            this.outpostArn(model.outpostArn);
            this.tags(model.tags);
            this.storageTier(model.storageTier);
            this.restoreExpiryTime(model.restoreExpiryTime);
            this.sseType(model.sseType);
            this.availabilityZone(model.availabilityZone);
            this.transferType(model.transferType);
            this.completionDurationMinutes(model.completionDurationMinutes);
            this.completionTime(model.completionTime);
            this.fullSnapshotSizeInBytes(model.fullSnapshotSizeInBytes);
            this.snapshotId(model.snapshotId);
            this.volumeId(model.volumeId);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.startTime(model.startTime);
            this.progress(model.progress);
            this.ownerId(model.ownerId);
            this.description(model.description);
            this.volumeSize(model.volumeSize);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dataEncryptionKeyId(model.dataEncryptionKeyId);
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStorageTier() {
            return this.storageTier;
        }

        public final void setStorageTier(String storageTier) {
            this.storageTier = storageTier;
        }

        @Override
        public final Builder storageTier(String storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        @Override
        public final Builder storageTier(StorageTier storageTier) {
            this.storageTier(storageTier == null ? null : storageTier.toString());
            return this;
        }

        public final Instant getRestoreExpiryTime() {
            return this.restoreExpiryTime;
        }

        public final void setRestoreExpiryTime(Instant restoreExpiryTime) {
            this.restoreExpiryTime = restoreExpiryTime;
        }

        @Override
        public final Builder restoreExpiryTime(Instant restoreExpiryTime) {
            this.restoreExpiryTime = restoreExpiryTime;
            return this;
        }

        public final String getSseType() {
            return this.sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getTransferType() {
            return this.transferType;
        }

        public final void setTransferType(String transferType) {
            this.transferType = transferType;
        }

        @Override
        public final Builder transferType(String transferType) {
            this.transferType = transferType;
            return this;
        }

        @Override
        public final Builder transferType(TransferType transferType) {
            this.transferType(transferType == null ? null : transferType.toString());
            return this;
        }

        public final Integer getCompletionDurationMinutes() {
            return this.completionDurationMinutes;
        }

        public final void setCompletionDurationMinutes(Integer completionDurationMinutes) {
            this.completionDurationMinutes = completionDurationMinutes;
        }

        @Override
        public final Builder completionDurationMinutes(Integer completionDurationMinutes) {
            this.completionDurationMinutes = completionDurationMinutes;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Long getFullSnapshotSizeInBytes() {
            return this.fullSnapshotSizeInBytes;
        }

        public final void setFullSnapshotSizeInBytes(Long fullSnapshotSizeInBytes) {
            this.fullSnapshotSizeInBytes = fullSnapshotSizeInBytes;
        }

        @Override
        public final Builder fullSnapshotSizeInBytes(Long fullSnapshotSizeInBytes) {
            this.fullSnapshotSizeInBytes = fullSnapshotSizeInBytes;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getProgress() {
            return this.progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDataEncryptionKeyId() {
            return this.dataEncryptionKeyId;
        }

        public final void setDataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
        }

        @Override
        public final Builder dataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
            return this;
        }

        @Override
        public CreateSnapshotResponse build() {
            return new CreateSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotResponse> {
        public Builder ownerAlias(String var1);

        public Builder outpostArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder storageTier(String var1);

        public Builder storageTier(StorageTier var1);

        public Builder restoreExpiryTime(Instant var1);

        public Builder sseType(String var1);

        public Builder sseType(SSEType var1);

        public Builder availabilityZone(String var1);

        public Builder transferType(String var1);

        public Builder transferType(TransferType var1);

        public Builder completionDurationMinutes(Integer var1);

        public Builder completionTime(Instant var1);

        public Builder fullSnapshotSizeInBytes(Long var1);

        public Builder snapshotId(String var1);

        public Builder volumeId(String var1);

        public Builder state(String var1);

        public Builder state(SnapshotState var1);

        public Builder stateMessage(String var1);

        public Builder startTime(Instant var1);

        public Builder progress(String var1);

        public Builder ownerId(String var1);

        public Builder description(String var1);

        public Builder volumeSize(Integer var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dataEncryptionKeyId(String var1);
    }
}

