/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import mediathek.tool.ReplaceList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilenameUtils {
    public static final String REGEXP_ILLEGAL_CHARACTERS_WINDOWS = "[:\\\\/*?|<>\"]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH = "[:/*?|<>\"]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_OTHERS = "[:\\\\/*|<>]";
    public static final String REGEXP_ILLEGAL_CHARACTERS_OTHERS_PATH = "[:\\\\*|<>]";
    private static final Logger logger = LogManager.getLogger();

    public static String checkDateiname(String name, boolean isPath) {
        Object ret = name;
        boolean isWindowsPath = false;
        String splitChar = SystemUtils.IS_OS_WINDOWS ? "\\\\" : "/";
        if (SystemUtils.IS_OS_WINDOWS) {
            ret = FilenameUtils.removeWindowsTrailingDots((String)ret);
            if (isPath && ((String)ret).length() > 1 && ((String)ret).charAt(1) == ':') {
                isWindowsPath = true;
                ret = ((String)ret).replaceFirst(":", "");
            }
        } else {
            ret = StringUtils.stripStart((String)ret, ".");
        }
        if (isPath && ((String)ret).contains(File.separator)) {
            String[] sa;
            Object str = "";
            for (String s2 : sa = ((String)ret).split(splitChar)) {
                if (s2.isEmpty()) continue;
                str = (String)str + File.separator + FilenameUtils.convertToNativeEncoding(s2, false);
            }
            if (!((String)ret).startsWith(File.separator)) {
                str = ((String)str).replaceFirst(splitChar, "");
            }
            if (((String)ret).endsWith(File.separator)) {
                str = (String)str + File.separator;
            }
            ret = str;
        } else {
            ret = FilenameUtils.convertToNativeEncoding((String)ret, false);
        }
        if (isWindowsPath) {
            if (((String)ret).length() == 1) {
                ret = (String)ret + ":";
            } else if (((String)ret).length() > 1) {
                ret = ((String)ret).charAt(0) + ":" + ((String)ret).substring(1);
            }
        }
        return ret;
    }

    protected static String removeWindowsTrailingDots(String fileName) {
        while (!fileName.isEmpty() && (fileName.endsWith(".") || fileName.endsWith(" "))) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return fileName;
    }

    private static String convertToNativeEncoding(String fileName, boolean isPath) {
        String ret = fileName;
        ret = FilenameUtils.removeIllegalCharacters(ret, isPath);
        try {
            CharsetEncoder charsetEncoder = Charset.defaultCharset().newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetEncoder.replaceWith(new byte[]{95});
            ByteBuffer buf = charsetEncoder.encode(CharBuffer.wrap(ret));
            if (buf.hasArray()) {
                ret = new String(buf.array());
            }
            ret = ret.replaceAll("\\u0000", "");
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String convertToASCIIEncoding(String fileName, boolean isPath) {
        String ret = fileName;
        ret = ret.replace("\u00e4", "ae");
        ret = ret.replace("\u00f6", "oe");
        ret = ret.replace("\u00fc", "ue");
        ret = ret.replace("\u00c4", "Ae");
        ret = ret.replace("\u00d6", "Oe");
        ret = ret.replace("\u00dc", "Ue");
        ret = ret.replace("\u00df", "ss");
        ret = FilenameUtils.cleanUnicode(ret);
        ret = FilenameUtils.removeIllegalCharacters(ret, isPath);
        try {
            CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetEncoder.replaceWith(new byte[]{95});
            ByteBuffer buf = charsetEncoder.encode(CharBuffer.wrap(ret));
            if (buf.hasArray()) {
                ret = new String(buf.array());
            }
            ret = ret.replaceAll("\\u0000", "");
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String cleanUnicode(String ret) {
        Object r = "";
        for (int i = 0; i < ret.length(); ++i) {
            char c = ret.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN) {
                r = (String)r + c;
                continue;
            }
            if (c == '\u00df') {
                r = (String)r + "\u00df";
                continue;
            }
            if (c == '\u00c2' || c == '\u00c0' || c == '\u00c5' || c == '\u00c1') {
                r = (String)r + "A";
                continue;
            }
            if (c == '\u00e5' || c == '\u00e1' || c == '\u00e0' || c == '\u00e2') {
                r = (String)r + "a";
                continue;
            }
            if (c == '\u010c') {
                r = (String)r + "C";
                continue;
            }
            if (c == '\u0107' || c == '\u010d' || c == '\u00e7') {
                r = (String)r + "c";
                continue;
            }
            if (c == '\u0110') {
                r = (String)r + "D";
                continue;
            }
            if (c == '\u00c9' || c == '\u00c8') {
                r = (String)r + "E";
                continue;
            }
            if (c == '\u00e9' || c == '\u00e8' || c == '\u00ea' || c == '\u011b' || c == '\u00eb') {
                r = (String)r + "e";
                continue;
            }
            if (c == '\u00ed') {
                r = (String)r + "i";
                continue;
            }
            if (c == '\u00f1') {
                r = (String)r + "n";
                continue;
            }
            if (c == '\u00f3' || c == '\u00f4' || c == '\u00f8') {
                r = (String)r + "o";
                continue;
            }
            if (c == '\u0160') {
                r = (String)r + "S";
                continue;
            }
            if (c == '\u015b' || c == '\u0161' || c == '\u015f') {
                r = (String)r + "s";
                continue;
            }
            if (c == '\u0142' || c == '\u0141') {
                r = (String)r + "t";
                continue;
            }
            if (c == '\u00fb' || c == '\u00f9') {
                r = (String)r + "u";
                continue;
            }
            if (c == '\u00fd') {
                r = (String)r + "y";
                continue;
            }
            if (c == '\u017d' || c == '\u0179') {
                r = (String)r + "Z";
                continue;
            }
            if (c == '\u017e' || c == '\u017a') {
                r = (String)r + "z";
                continue;
            }
            if (c == '\u00e6') {
                r = (String)r + "ae";
                continue;
            }
            if (c == '\u2013') {
                r = (String)r + "-";
                continue;
            }
            if (c == '\u201e') {
                r = (String)r + "\"";
                continue;
            }
            if (c == '\u201d' || c == '\u201c' || c == '\u00ab' || c == '\u00bb') {
                r = (String)r + "\"";
                continue;
            }
            if (c == '?') {
                r = (String)r + "?";
                continue;
            }
            if (c == '\u00b0' || c == '\u2122') continue;
            if (c == '\u2026') {
                r = (String)r + "...";
                continue;
            }
            if (c == '\u20ac') {
                r = (String)r + "\u20ac";
                continue;
            }
            if (c == '\u00b4' || c == '\u2019' || c == '\u2018' || c == '\u00bf') {
                r = (String)r + "'";
                continue;
            }
            if (c == '?') {
                r = (String)r + "?";
                continue;
            }
            if (c == '\u0096') {
                r = (String)r + "-";
                continue;
            }
            if (c == '\u0085' || c == '\u0080' || c == '\u0084' || c == '\u0092' || c == '\u0093') continue;
            if (c == '\u0091') {
                r = (String)r + "-";
                continue;
            }
            if (c == '\n') continue;
            r = (String)r + "_";
        }
        return r;
    }

    public static String removeIllegalCharacters(String input, boolean isPath) {
        String ret = input;
        if (SystemUtils.IS_OS_WINDOWS) {
            ret = FilenameUtils.removeWindowsTrailingDots(ret);
            ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH : REGEXP_ILLEGAL_CHARACTERS_WINDOWS, "_");
        } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            ret = StringUtils.stripStart(ret, ".");
            ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_OTHERS_PATH : REGEXP_ILLEGAL_CHARACTERS_OTHERS, "_");
        } else {
            logger.warn("This code path should NOT have been taken");
            ret = StringUtils.stripStart(ret, ".");
            ret = ret.replaceAll(isPath ? REGEXP_ILLEGAL_CHARACTERS_WINDOWS_PATH : REGEXP_ILLEGAL_CHARACTERS_WINDOWS, "_");
        }
        return ret;
    }

    public static String replaceLeerDateiname(String name, boolean isPath, boolean userReplace, boolean onlyAscii) {
        Object ret = name;
        boolean isWindowsPath = false;
        if (SystemUtils.IS_OS_WINDOWS && isPath && ((String)ret).length() > 1 && ((String)ret).charAt(1) == ':') {
            isWindowsPath = true;
            ret = ((String)ret).replaceFirst(":", "");
        }
        if (userReplace) {
            ret = ReplaceList.replace((String)ret, isPath);
        }
        ret = onlyAscii ? FilenameUtils.convertToASCIIEncoding((String)ret, isPath) : FilenameUtils.convertToNativeEncoding((String)ret, isPath);
        if (isWindowsPath) {
            if (((String)ret).length() == 1) {
                ret = (String)ret + ":";
            } else if (((String)ret).length() > 1) {
                ret = ((String)ret).charAt(0) + ":" + ((String)ret).substring(1);
            }
        }
        return ret;
    }
}

