/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.AbstractEventListCalculation;

final class Sum {
    Sum() {
    }

    static final class SumLong<N extends Number>
    extends AbstractEventListCalculation<Long, N> {
        public SumLong(EventList<N> source2) {
            super(new Long(0L), source2);
        }

        @Override
        protected void inserted(Number element) {
            this.setValue(new Long((Long)this.getValue() + element.longValue()));
        }

        @Override
        protected void deleted(Number element) {
            this.setValue(new Long((Long)this.getValue() - element.longValue()));
        }

        @Override
        protected void updated(Number oldElement, Number newElement) {
            this.setValue(new Long((Long)this.getValue() - oldElement.longValue() + newElement.longValue()));
        }
    }

    static final class SumInteger<N extends Number>
    extends AbstractEventListCalculation<Integer, N> {
        public SumInteger(EventList<N> source2) {
            super(new Integer(0), source2);
        }

        @Override
        protected void inserted(Number element) {
            this.setValue(new Integer((Integer)this.getValue() + element.intValue()));
        }

        @Override
        protected void deleted(Number element) {
            this.setValue(new Integer((Integer)this.getValue() - element.intValue()));
        }

        @Override
        protected void updated(Number oldElement, Number newElement) {
            this.setValue(new Integer((Integer)this.getValue() - oldElement.intValue() + newElement.intValue()));
        }
    }

    static final class SumDouble<N extends Number>
    extends AbstractEventListCalculation<Double, N> {
        public SumDouble(EventList<N> source2) {
            super(new Double(0.0), source2);
        }

        @Override
        protected void inserted(Number element) {
            this.setValue(new Double((Double)this.getValue() + element.doubleValue()));
        }

        @Override
        protected void deleted(Number element) {
            this.setValue(new Double((Double)this.getValue() - element.doubleValue()));
        }

        @Override
        protected void updated(Number oldElement, Number newElement) {
            this.setValue(new Double((Double)this.getValue() - oldElement.doubleValue() + newElement.doubleValue()));
        }
    }

    static final class SumFloat<N extends Number>
    extends AbstractEventListCalculation<Float, N> {
        public SumFloat(EventList<N> source2) {
            super(new Float(0.0f), source2);
        }

        @Override
        protected void inserted(Number element) {
            this.setValue(new Float(((Float)this.getValue()).floatValue() + element.floatValue()));
        }

        @Override
        protected void deleted(Number element) {
            this.setValue(new Float(((Float)this.getValue()).floatValue() - element.floatValue()));
        }

        @Override
        protected void updated(Number oldElement, Number newElement) {
            this.setValue(new Float(((Float)this.getValue()).floatValue() - oldElement.floatValue() + newElement.floatValue()));
        }
    }
}

