/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

class SplitPanel
extends JPanel {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    private final JSplitPane[] outerPanels;

    public SplitPanel() {
        this.setLayout(new BorderLayout());
        int[] directions = new int[]{0, 1, 2, 3};
        this.outerPanels = new JSplitPane[directions.length];
        for (int i = 0; i < directions.length; ++i) {
            this.outerPanels[directions[i]] = new JSplitPane();
            this.outerPanels[directions[i]].setBorder(new EmptyBorder(0, 0, 0, 0));
            this.outerPanels[directions[i]].setContinuousLayout(true);
        }
        this.buildLayout();
        this.restorePrefs();
    }

    private void buildLayout() {
        this.removeAll();
        this.outerPanels[0].setOrientation(0);
        this.outerPanels[2].setOrientation(0);
        this.outerPanels[3].setOrientation(1);
        this.outerPanels[1].setOrientation(1);
        this.outerPanels[2].setTopComponent(this.outerPanels[0]);
        this.outerPanels[3].setRightComponent(this.outerPanels[2]);
        this.outerPanels[1].setLeftComponent(this.outerPanels[3]);
        this.add((Component)this.outerPanels[1], "Center");
    }

    public void removeAllOuterPanels() {
        JComponent p = (JComponent)this.outerPanels[0].getTopComponent();
        p.removeAll();
        p.setVisible(false);
        p = (JComponent)this.outerPanels[3].getLeftComponent();
        p.removeAll();
        p.setVisible(false);
        p = (JComponent)this.outerPanels[2].getBottomComponent();
        p.removeAll();
        p.setVisible(false);
        p = (JComponent)this.outerPanels[1].getRightComponent();
        p.removeAll();
        p.setVisible(false);
    }

    public void setDivLoc(int panel, double loc) {
        this.outerPanels[panel].setDividerLocation(loc);
    }

    public int getDivLoc(int panel) {
        return this.outerPanels[panel].getDividerLocation();
    }

    public void savePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        for (int i = 0; i < 4; ++i) {
            prefs.putInt("divLoc" + i, this.outerPanels[i].getDividerLocation());
        }
    }

    public void restorePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        for (int i = 0; i < 4; ++i) {
            this.outerPanels[i].setDividerLocation(prefs.getInt("divLoc" + i, 300));
        }
    }

    public JTabbedPane getPanel(int location) {
        Component component;
        switch (location) {
            case 0: {
                component = this.outerPanels[0].getTopComponent();
                break;
            }
            case 1: {
                component = this.outerPanels[1].getRightComponent();
                break;
            }
            case 2: {
                component = this.outerPanels[2].getBottomComponent();
                break;
            }
            case 3: {
                component = this.outerPanels[3].getLeftComponent();
                break;
            }
            default: {
                component = null;
            }
        }
        return (JTabbedPane)component;
    }

    public void adjustDividerSizes() {
        JSplitPane splitPane = this.outerPanels[0];
        if (splitPane.getTopComponent().isVisible()) {
            splitPane.setDividerSize(2);
        } else {
            splitPane.setDividerSize(0);
        }
        splitPane = this.outerPanels[3];
        if (splitPane.getLeftComponent().isVisible()) {
            splitPane.setDividerSize(2);
        } else {
            splitPane.setDividerSize(0);
        }
        splitPane = this.outerPanels[2];
        if (splitPane.getBottomComponent().isVisible()) {
            splitPane.setDividerSize(2);
        } else {
            splitPane.setDividerSize(0);
        }
        splitPane = this.outerPanels[1];
        if (splitPane.getRightComponent().isVisible()) {
            splitPane.setDividerSize(2);
        } else {
            splitPane.setDividerSize(0);
        }
    }

    public void addComponent(JComponent component, int location) {
        switch (location) {
            case 4: {
                this.outerPanels[0].remove(this.outerPanels[0].getBottomComponent());
                this.outerPanels[0].setBottomComponent(component);
                break;
            }
            case 0: {
                this.outerPanels[0].remove(this.outerPanels[0].getTopComponent());
                this.outerPanels[0].setTopComponent(component);
                break;
            }
            case 3: {
                this.outerPanels[3].remove(this.outerPanels[3].getLeftComponent());
                this.outerPanels[3].setLeftComponent(component);
                break;
            }
            case 2: {
                this.outerPanels[2].remove(this.outerPanels[2].getBottomComponent());
                this.outerPanels[2].setBottomComponent(component);
                break;
            }
            case 1: {
                this.outerPanels[1].remove(this.outerPanels[1].getRightComponent());
                this.outerPanels[1].setRightComponent(component);
            }
        }
    }
}

