/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import net.sf.freecol.client.ClientTestHelper;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class MoveTest
extends FreeColTestCase {
    private static final TileType plains = MoveTest.spec().getTileType("model.tile.plains");
    private static final UnitType pioneerType = MoveTest.spec().getUnitType("model.unit.hardyPioneer");

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleMove() {
        ServerGame game = ServerTestHelper.startServerGame(MoveTest.getTestMap(plains));
        Map map = game.getMap();
        FreeColClient client = null;
        try {
            client = ClientTestHelper.startClient(ServerTestHelper.getServer(), MoveTest.spec());
            Player dutch = game.getPlayerByNationId("model.nation.dutch");
            Tile plain1 = map.getTile(5, 8);
            plain1.setExplored(dutch, true);
            Tile plain2 = map.getTile(5, 7);
            plain2.setExplored(dutch, true);
            ServerUnit hardyPioneer = new ServerUnit(game, plain1, dutch, pioneerType);
            client.getPreGameController().startGameHandler();
            MoveTest.assertEquals((Object)plain1.getNeighbourOrNull(Direction.NE), (Object)plain2);
            client.getInGameController().moveDirection(hardyPioneer, Direction.NE, false);
        }
        finally {
            if (client != null) {
                ClientTestHelper.stopClient(client);
            }
        }
    }
}

