-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  CURRENT_DATABASE()::INFORMATION_SCHEMA.SQL_IDENTIFIER AS CONSTRAINT_CATALOG,
  NAMESPACES.NSPNAME AS CONSTRAINT_SCHEMA,
  CONSTRAINTS.CONNAME AS CONSTRAINT_NAME,
  TABLES.RELNAME AS TABLE_NAME,
  PG_CATALOG.OBJ_DESCRIPTION(CONSTRAINTS.OID, 'pg_constraint')
    AS REMARKS,
  PG_GET_CONSTRAINTDEF(CONSTRAINTS.OID) 
    AS CONSTRAINT_DEFINITION
FROM
  PG_CONSTRAINT CONSTRAINTS
  INNER JOIN PG_NAMESPACE AS NAMESPACES
    ON CONSTRAINTS.CONNAMESPACE = NAMESPACES.OID
  INNER JOIN PG_CATALOG.PG_CLASS TABLES
    ON CONSTRAINTS.CONRELID = TABLES.OID
WHERE
  NAMESPACES.NSPNAME NOT IN ('pg_catalog', 'information_schema')
  AND NAMESPACES.NSPNAME !~ '^pg_toast'
  AND TABLES.RELKIND IN ('r', 'v')
