/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import us.fatehi.utility.property.PropertyName;

class LinterForeignKeySelfReference
extends BaseLinter {
    LinterForeignKeySelfReference(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setSeverity(LintSeverity.critical);
    }

    @Override
    public String getSummary() {
        return "foreign key self-references primary key";
    }

    @Override
    protected void lint(Table table, Connection connections) {
        Objects.requireNonNull(table, "No table provided");
        List<ForeignKey> selfReferencingForeignKeys = this.findSelfReferencingForeignKeys(table);
        for (ForeignKey foreignKey : selfReferencingForeignKeys) {
            this.addTableLint(table, this.getSummary(), foreignKey);
        }
    }

    private List<ForeignKey> findSelfReferencingForeignKeys(Table table) {
        ArrayList<ForeignKey> selfReferencingForeignKeys = new ArrayList<ForeignKey>();
        if (table != null && !(table instanceof View)) {
            block0: for (ForeignKey foreignKey : table.getImportedForeignKeys()) {
                for (ColumnReference columnReference : foreignKey) {
                    Column fkColumn;
                    Column pkColumn = columnReference.getPrimaryKeyColumn();
                    if (!pkColumn.equals(fkColumn = columnReference.getForeignKeyColumn())) continue;
                    selfReferencingForeignKeys.add(foreignKey);
                    continue block0;
                }
            }
        }
        return selfReferencingForeignKeys;
    }
}

