/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfigurationRoute;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfigurationRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessInstanceOpenVpnClientConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessInstanceOpenVpnClientConfiguration> {
    private static final SdkField<String> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Config").getter(VerifiedAccessInstanceOpenVpnClientConfiguration.getter(VerifiedAccessInstanceOpenVpnClientConfiguration::config)).setter(VerifiedAccessInstanceOpenVpnClientConfiguration.setter(Builder::config)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").unmarshallLocationName("config").build()}).build();
    private static final SdkField<List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(VerifiedAccessInstanceOpenVpnClientConfiguration.getter(VerifiedAccessInstanceOpenVpnClientConfiguration::routes)).setter(VerifiedAccessInstanceOpenVpnClientConfiguration.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet").unmarshallLocationName("routeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessInstanceOpenVpnClientConfigurationRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_FIELD, ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifiedAccessInstanceOpenVpnClientConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String config;
    private final List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes;

    private VerifiedAccessInstanceOpenVpnClientConfiguration(BuilderImpl builder) {
        this.config = builder.config;
        this.routes = builder.routes;
    }

    public final String config() {
        return this.config;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes() {
        return this.routes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstanceOpenVpnClientConfiguration)) {
            return false;
        }
        VerifiedAccessInstanceOpenVpnClientConfiguration other = (VerifiedAccessInstanceOpenVpnClientConfiguration)obj;
        return Objects.equals(this.config(), other.config()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessInstanceOpenVpnClientConfiguration").add("Config", (Object)this.config()).add("Routes", this.hasRoutes() ? this.routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Config", CONFIG_FIELD);
        map.put("RouteSet", ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstanceOpenVpnClientConfiguration, T> g) {
        return obj -> g.apply((VerifiedAccessInstanceOpenVpnClientConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String config;
        private List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstanceOpenVpnClientConfiguration model) {
            this.config(model.config);
            this.routes(model.routes);
        }

        public final String getConfig() {
            return this.config;
        }

        public final void setConfig(String config) {
            this.config = config;
        }

        @Override
        public final Builder config(String config) {
            this.config = config;
            return this;
        }

        public final List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder> getRoutes() {
            List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder> result = VerifiedAccessInstanceOpenVpnClientConfigurationRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.BuilderImpl> routes) {
            this.routes = VerifiedAccessInstanceOpenVpnClientConfigurationRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes) {
            this.routes = VerifiedAccessInstanceOpenVpnClientConfigurationRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(VerifiedAccessInstanceOpenVpnClientConfigurationRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (VerifiedAccessInstanceOpenVpnClientConfigurationRoute)((VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder)VerifiedAccessInstanceOpenVpnClientConfigurationRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VerifiedAccessInstanceOpenVpnClientConfiguration build() {
            return new VerifiedAccessInstanceOpenVpnClientConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessInstanceOpenVpnClientConfiguration> {
        public Builder config(String var1);

        public Builder routes(Collection<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> var1);

        public Builder routes(VerifiedAccessInstanceOpenVpnClientConfigurationRoute ... var1);

        public Builder routes(Consumer<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder> ... var1);
    }
}

