"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const react_json_tree_1 = __importDefault(require("react-json-tree"));
const defaultTheme = {
    base00: "transparent",
    base01: "#073642",
    base02: "#586e75",
    base03: "#657b83",
    base04: "#839496",
    base05: "#93a1a1",
    base06: "#eee8d5",
    base07: "#fdf6e3",
    base08: "#dc322f",
    base09: "#cb4b16",
    base0A: "#b58900",
    base0B: "#66BB6A",
    base0C: "#2aa198",
    base0D: "#268bd2",
    base0E: "#6c71c4",
    base0F: "#d33682"
};
const darkTheme = Object.assign({}, defaultTheme, { base0B: "#EDF3F7" });
/** @component */
class Json extends React.PureComponent {
    constructor() {
        super(...arguments);
        //   #3435
        this.shouldExpandNode = () => {
            if (this.props.metadata && this.props.metadata.expanded) {
                return true;
            }
            return false;
        };
    }
    render() {
        const theme = this.props.theme === "dark" ? darkTheme : defaultTheme;
        return (React.createElement(react_json_tree_1.default, { data: this.props.data, theme: theme, invertTheme: false, hideRoot: true, shouldExpandNode: this.shouldExpandNode }));
    }
}
exports.Json = Json;
Json.defaultProps = {
    data: null,
    mediaType: "application/json",
    theme: "light",
    metadata: { expanded: true }
};
exports.default = Json;
