/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.DeflaterOutputStream;
import com.jcraft.jzlib.GZIPException;
import java.io.IOException;
import java.io.OutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, 512);
    }

    public GZIPOutputStream(OutputStream out, int size2) throws IOException {
        this(out, size2, true);
    }

    public GZIPOutputStream(OutputStream out, int size2, boolean close_out) throws IOException {
        this(out, new Deflater(-1, 31), size2, close_out);
        this.mydeflater = true;
    }

    public GZIPOutputStream(OutputStream out, Deflater deflater, int size2, boolean close_out) throws IOException {
        super(out, deflater, size2, close_out);
    }

    private void check() throws GZIPException {
        if (this.deflater.dstate.status != 42) {
            throw new GZIPException("header is already written.");
        }
    }

    public void setModifiedTime(long mtime2) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setModifiedTime(mtime2);
    }

    public void setOS(int os) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setOS(os);
    }

    public void setName(String name2) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setName(name2);
    }

    public void setComment(String comment2) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setComment(comment2);
    }

    public long getCRC() throws GZIPException {
        if (this.deflater.dstate.status != 666) {
            throw new GZIPException("checksum is not calculated yet.");
        }
        return this.deflater.dstate.getGZIPHeader().getCRC();
    }
}

