/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ExportedCollectionsInfo;
import org.jetbrains.kotlin.ir.backend.js.lower.PrepareCollectionsToExportLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/RemoveImplicitExportsFromCollections;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "strictImplicitExport", "", "jsImplicitExportCtor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getJsImplicitExportCtor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "jsImplicitExportCtor$delegate", "Lkotlin/Lazy;", "exportedCollectionsInfo", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ExportedCollectionsInfo;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "removeJsImplicitExport", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPrepareCollectionsToExportLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepareCollectionsToExportLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/RemoveImplicitExportsFromCollections\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n774#2:238\n865#2,2:239\n*S KotlinDebug\n*F\n+ 1 PrepareCollectionsToExportLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/RemoveImplicitExportsFromCollections\n*L\n231#1:238\n231#1:239,2\n*E\n"})
public final class RemoveImplicitExportsFromCollections
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean strictImplicitExport;
    @NotNull
    private final Lazy jsImplicitExportCtor$delegate;
    @NotNull
    private final ExportedCollectionsInfo exportedCollectionsInfo;

    public RemoveImplicitExportsFromCollections(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.strictImplicitExport = this.context.getConfiguration().getBoolean(JSConfigurationKeys.GENERATE_STRICT_IMPLICIT_EXPORT);
        this.jsImplicitExportCtor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> RemoveImplicitExportsFromCollections.jsImplicitExportCtor_delegate$lambda$0(this));
        this.exportedCollectionsInfo = new ExportedCollectionsInfo(this.context);
    }

    private final IrConstructorSymbol getJsImplicitExportCtor() {
        Lazy lazy = this.jsImplicitExportCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.strictImplicitExport && declaration instanceof IrClass && this.exportedCollectionsInfo.getExportableSymbols().contains(((IrClass)declaration).getSymbol()) && AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)declaration)) {
            this.removeJsImplicitExport(declaration);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeJsImplicitExport(IrDeclaration $this$removeJsImplicitExport) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = $this$removeJsImplicitExport.getAnnotations();
        IrDeclaration irDeclaration = $this$removeJsImplicitExport;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrConstructorCall it = (IrConstructorCall)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getSymbol(), (Object)this.getJsImplicitExportCtor()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        irDeclaration.setAnnotations((List)destination$iv$iv);
    }

    private static final IrConstructorSymbol jsImplicitExportCtor_delegate$lambda$0(RemoveImplicitExportsFromCollections this$0) {
        return PrepareCollectionsToExportLoweringKt.access$getPrimaryConstructorSymbol(this$0.context.getIntrinsics().getJsImplicitExportAnnotationSymbol());
    }
}

