/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GrForBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        GrForStatement forStatement;
        if (editor == null) {
            GrForBodyFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            GrForBodyFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            GrForBodyFixer.$$$reportNull$$$0(2);
        }
        if ((forStatement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrForStatement.class)) == null) {
            return;
        }
        Document doc = editor.getDocument();
        GrStatement body = forStatement.getBody();
        if (body instanceof GrBlockStatement) {
            return;
        }
        if (body != null && GrForBodyFixer.startLine(doc, body) == GrForBodyFixer.startLine(doc, forStatement)) {
            return;
        }
        PsiElement eltToInsertAfter = forStatement.getRParenth();
        String text = "{}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement;
            text = "){}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }

    static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrForBodyFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

