/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboost;

import ai.catboost.CatBoostModel;
import ai.catboost.CatBoostPredictions;
import com.jetbrains.ml.tools.model.ClassesProbabilities;
import com.jetbrains.ml.tools.model.Classifier;
import com.jetbrains.ml.tools.model.DatasetColumns;
import com.jetbrains.ml.tools.model.DecisionFunctionKt;
import com.jetbrains.ml.tools.model.catboost.CatBoostRegressorKt;
import com.jetbrains.ml.tools.model.catboost.CatBoostRow;
import com.jetbrains.ml.tools.model.catboost.CatBoostRows;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006*\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/ml/tools/model/catboost/CatBoostClassifier;", "Lcom/jetbrains/ml/tools/model/Classifier;", "model", "Lai/catboost/CatBoostModel;", "(Lai/catboost/CatBoostModel;)V", "predictedClasses", "", "", "getPredictedClasses", "()Ljava/util/List;", "predict", "Lcom/jetbrains/ml/tools/model/ClassesProbabilities;", "row", "Lcom/jetbrains/ml/tools/model/DatasetColumns;", "parameters", "", "", "predictBatch", "rows", "sigmoid", "", "x", "softmax", "", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nCatBoostClassifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatBoostClassifier.kt\ncom/jetbrains/ml/tools/model/catboost/CatBoostClassifier\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,80:1\n147#2:81\n1549#3:82\n1620#3,3:83\n1549#3:87\n1620#3,3:88\n1549#3:91\n1620#3,3:92\n1549#3:99\n1620#3,3:100\n1#4:86\n11125#5:95\n11460#5,3:96\n*S KotlinDebug\n*F\n+ 1 CatBoostClassifier.kt\ncom/jetbrains/ml/tools/model/catboost/CatBoostClassifier\n*L\n21#1:81\n22#1:82\n22#1:83,3\n59#1:87\n59#1:88,3\n64#1:91\n64#1:92,3\n77#1:99\n77#1:100,3\n75#1:95\n75#1:96,3\n*E\n"})
public final class CatBoostClassifier
implements Classifier {
    @NotNull
    private final CatBoostModel model;
    @NotNull
    private final List<String> predictedClasses;

    /*
     * WARNING - void declaration
     */
    public CatBoostClassifier(@NotNull CatBoostModel model2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable this_$iv;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        Json json = (Json)Json.Default;
        Map<String, String> map = this.model.getMetadata();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getMetadata(...)");
        Object object = MapsKt.getValue(map, (Object)"class_params");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        String string$iv = (String)object;
        boolean $i$f$decodeFromString22 = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        this_$iv = (Iterable)JsonElementKt.getJsonArray((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv)), (Object)"class_names")));
        CatBoostClassifier catBoostClassifier = this;
        boolean $i$f$map = false;
        void $i$f$decodeFromString22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
        }
        catBoostClassifier.predictedClasses = (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<String> getPredictedClasses() {
        return this.predictedClasses;
    }

    @Override
    @NotNull
    public ClassesProbabilities predict(@NotNull DatasetColumns row, @NotNull Map<String, ? extends Object> parameters) {
        ClassesProbabilities classesProbabilities;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        CatBoostRow cbRow = CatBoostRegressorKt.toCatBoostFormat(row, this.model);
        CatBoostPredictions catBoostPredictions = this.model.predict(cbRow.getNumerical(), cbRow.getCategorical(), cbRow.getText(), cbRow.getEmbeddings());
        if (catBoostPredictions == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CatBoostPredictions prediction = catBoostPredictions;
        if (!(this.getPredictedClasses().size() > 1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (this.getPredictedClasses().size() == 2) {
            if (!(prediction.getPredictionDimension() == 1)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        } else if (!(prediction.getPredictionDimension() == this.getPredictedClasses().size())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(prediction.getObjectCount() == 1)) {
            boolean bl = false;
            String string = String.valueOf(prediction.getObjectCount());
            throw new IllegalStateException(string.toString());
        }
        if (this.getPredictedClasses().size() == 2) {
            double p = this.sigmoid(prediction.get(0, 0));
            Object[] objectArray = new Double[]{1.0 - p, p};
            classesProbabilities = DecisionFunctionKt.createClassesProbabilities(this, CollectionsKt.listOf((Object[])objectArray));
        } else {
            Classifier classifier = this;
            double[] dArray = prediction.copyObjectPredictions(0);
            Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyObjectPredictions(...)");
            classesProbabilities = DecisionFunctionKt.createClassesProbabilities(classifier, this.softmax(dArray));
        }
        return classesProbabilities;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ClassesProbabilities> predictBatch(@NotNull List<DatasetColumns> rows, @NotNull Map<String, ? extends Object> parameters) {
        List list;
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        CatBoostRows cbRows = CatBoostRegressorKt.toCatBoostFormat(rows, this.model);
        CatBoostPredictions catBoostPredictions = this.model.predict(cbRows.getNumerical(), cbRows.getCategorical(), cbRows.getText(), cbRows.getEmbeddings());
        if (catBoostPredictions == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CatBoostPredictions prediction = catBoostPredictions;
        if (!(this.getPredictedClasses().size() > 1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (this.getPredictedClasses().size() == 2) {
            if (!(prediction.getPredictionDimension() == 1)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        } else if (!(prediction.getPredictionDimension() == this.getPredictedClasses().size())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(prediction.getObjectCount() == rows.size())) {
            boolean $i$a$-check-CatBoostClassifier$predictBatch$22 = false;
            String $i$a$-check-CatBoostClassifier$predictBatch$22 = String.valueOf(prediction.getObjectCount());
            throw new IllegalStateException($i$a$-check-CatBoostClassifier$predictBatch$22.toString());
        }
        if (this.getPredictedClasses().size() == 2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)rows);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double p = this.sigmoid(prediction.get((int)it, 0));
                Object[] objectArray = new Double[]{1.0 - p, p};
                collection.add(DecisionFunctionKt.createClassesProbabilities(this, CollectionsKt.listOf((Object[])objectArray)));
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)rows);
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Classifier classifier = this;
                double[] dArray = prediction.copyObjectPredictions(it);
                Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyObjectPredictions(...)");
                collection.add(DecisionFunctionKt.createClassesProbabilities(classifier, this.softmax(dArray)));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final double sigmoid(double x) {
        return 1.0 / (1.0 + Math.pow(Math.E, -x));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> softmax(double[] $this$softmax) {
        void $this$mapTo$iv$iv;
        double it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        double[] $this$map$iv = $this$softmax;
        boolean $i$f$map = false;
        double[] dArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo22 = false;
        int n = ((void)$this$mapTo$iv$iv2).length;
        for (int i = 0; i < n; ++i) {
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv2[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Math.exp(it));
        }
        List exps = (List)destination$iv$iv;
        double sumExps = CollectionsKt.sumOfDouble((Iterable)exps);
        Iterable $this$map$iv2 = exps;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void exp;
            it = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add((double)(exp / sumExps));
        }
        return (List)destination$iv$iv2;
    }
}

