"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../../../utils/utils");
var ComponentDepFactory = /** @class */ (function () {
    function ComponentDepFactory(helper, configuration) {
        this.helper = helper;
        this.configuration = configuration;
    }
    ComponentDepFactory.prototype.create = function (file, srcFile, name, props, IO) {
        // console.log(util.inspect(props, { showHidden: true, depth: 10 }));
        var componentDep = {
            name: name,
            id: 'component-' + name + '-' + Date.now(),
            file: file,
            // animations?: string[]; // TODO
            changeDetection: this.helper.getComponentChangeDetection(props),
            encapsulation: this.helper.getComponentEncapsulation(props),
            // entryComponents?: string; // TODO waiting doc infos
            exportAs: this.helper.getComponentExportAs(props),
            host: this.helper.getComponentHost(props),
            inputs: this.helper.getComponentInputsMetadata(props),
            // interpolation?: string; // TODO waiting doc infos
            moduleId: this.helper.getComponentModuleId(props),
            outputs: this.helper.getComponentOutputs(props),
            providers: this.helper.getComponentProviders(props),
            // queries?: Deps[]; // TODO
            selector: this.helper.getComponentSelector(props),
            styleUrls: this.helper.getComponentStyleUrls(props),
            styles: this.helper.getComponentStyles(props),
            template: this.helper.getComponentTemplate(props),
            templateUrl: this.helper.getComponentTemplateUrl(props),
            viewProviders: this.helper.getComponentViewProviders(props),
            inputsClass: IO.inputs,
            outputsClass: IO.outputs,
            propertiesClass: IO.properties,
            methodsClass: IO.methods,
            hostBindings: IO.hostBindings,
            hostListeners: IO.hostListeners,
            description: IO.description,
            type: 'component',
            sourceCode: srcFile.getText(),
            exampleUrls: this.helper.getComponentExampleUrls(srcFile.getText())
        };
        if (this.configuration.mainData.disableLifeCycleHooks) {
            componentDep.methodsClass = utils_1.cleanLifecycleHooksFromMethods(componentDep.methodsClass);
        }
        if (IO.jsdoctags && IO.jsdoctags.length > 0) {
            componentDep.jsdoctags = IO.jsdoctags[0].tags;
        }
        if (IO.constructor) {
            componentDep.constructorObj = IO.constructor;
        }
        if (IO.extends) {
            componentDep.extends = IO.extends;
        }
        if (IO.implements && IO.implements.length > 0) {
            componentDep.implements = IO.implements;
        }
        if (IO.accessors) {
            componentDep.accessors = IO.accessors;
        }
        return componentDep;
    };
    return ComponentDepFactory;
}());
exports.ComponentDepFactory = ComponentDepFactory;
//# sourceMappingURL=component-dep.factory.js.map