"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThemeProvider = exports.themes = exports.THEME_ID = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const react_1 = require("@emotion/react");
const Sizes_1 = require("./Sizes");
const colors_1 = require("../Identity/colors");
const colors_v2_1 = require("../Identity/colors-v2");
var THEME_ID;
(function (THEME_ID) {
    THEME_ID["DARK"] = "THEME_DARK";
    THEME_ID["LIGHT"] = "THEME_LIGHT";
    THEME_ID["DEFAULT"] = "THEME_DEFAULT";
})(THEME_ID = exports.THEME_ID || (exports.THEME_ID = {}));
exports.themes = {
    [THEME_ID.DEFAULT]: {
        fontSizes: Sizes_1.fontSizes,
        Button: {
            primaryBg: 'var(--accent-color)',
            primaryHoverBg: 'var(--button-primary-hover)',
            primaryActiveBg: 'var(--button-primary-active)',
            primaryActiveBorder: 'var(--button-primary-active-border)',
            primaryFocusBorder: 'var(--button-primary-focus-border)',
            primaryDisabledBg: 'var(--button-primary-disabled-bg)',
            primaryDisabledText: 'var(--button-primary-disabled-text)',
            secondaryActiveBg: 'var(--button-secondary-active-bg)',
            secondaryActiveBorder: 'var(--button-secondary-active-border)',
            secondaryHoverBorder: 'var(--button-secondary-hover-border)',
            tertiaryBg: 'var(--button-tertiary-bg)',
            tertiaryBorder: 'var(--button-tertiary-border)',
            tertiaryHoverBg: 'var(--button-tertiary-hover-bg)',
            tertiaryHoverBorder: 'var(--button-tertiary-hover-border)',
            tertiarydisabledBg: 'var(--button-tertiary-disabled-bg)',
            tertiaryDisabledBorder: 'var(--button-tertiary-disabled-border)',
            tertiaryActiveBg: 'var(--accent-color-highlight)',
        },
        Checkbox: {
            background: 'var(--checkbox-background)',
            border: 'var(--checkbox-border)',
            borderFocused: 'var(--accent-color)',
            disableBgColor: 'var(--checkbox-background-disabled)',
            disableBorderColor: 'var(--checkbox-border-disabled)',
            disablecheckedBgColor: 'var(--checkbox-background-disabled-selected)',
            invalidBorderColor: 'var(--danger-color)',
        },
        IconButton: {
            activePrimaryBgColor: 'var(--accent-color-highlight)',
            focusBorderColor: 'var(--accent-color-border)',
            hoverPrimaryBgColor: 'var(--icon-button-primary-hover-bg)',
            primaryActiveFillColor: 'var(--icon-primary-active-fill)',
            primaryBgColor: 'var(--icon-button-primary-enabled-bg)',
            primaryBorderColor: 'var(--icon-button-primary-border)',
            primaryDisabledBgColor: 'var(--icon-button-primary-disabled-bg)',
            primaryDisabledBorderColor: 'var(--icon-button-primary-disabled-border)',
            primaryHoverBorderColor: 'var(--icon-button-primary-hover-border)',
            secondaryActiveBorderColor: 'var(--icon-secondary-active-border)',
        },
        IndicatorRangeInput: {
            thumb: 'var(--indicator-range-input-thumb)',
            trackBg: 'var(--indicator-range-input-track-bg)',
        },
        Input: {
            backgroundColor: 'var(--text-input-background)',
            backgroundColorDisabled: 'var(--text-input-disabled)',
            labelColor: 'var(--text-input-label)',
            placeholderColor: 'var(--text-input-placeholder)',
            borderHover: 'var(--text-input-border-hover)',
        },
        Select: {
            borderColor: 'var(--text-input-border)',
            contrastTextColor: 'var(--text-input-background)',
            disabledColor: 'var(--text-input-placeholder)',
            focusedDescriptionColor: 'var(--select-focused-description)',
            optionHoverBg: 'var(--accent-color-highlight)',
            selectedActiveBg: 'var(--button-primary-hover)',
        },
        Tooltip: {
            backgroundColor: 'var(--button-tertiary-bg)',
            color: 'var(--main-color)',
        },
        general: {
            backgroundColor: 'var(--app-bg)',
            color: 'var(--main-color)',
            dangerColor: 'var(--danger-color)',
            primaryColor: 'var(--accent-color)',
            contrastColor: 'var(--text-input-background)',
            focusColor: 'var(--accent-color-focus)',
        },
    },
    [THEME_ID.LIGHT]: {
        fontSizes: Sizes_1.fontSizes,
        Button: {
            primaryBg: 'var(--accent-color)',
            primaryHoverBg: 'var(--button-primary-hover)',
            primaryActiveBg: 'var(--button-primary-active)',
            primaryActiveBorder: 'var(--button-primary-active-border)',
            primaryFocusBorder: 'var(--button-primary-focus-border)',
            primaryDisabledBg: 'var(--button-primary-disabled-bg)',
            primaryDisabledText: 'var(--button-primary-disabled-text)',
            secondaryActiveBg: 'var(--button-secondary-active-bg)',
            secondaryActiveBorder: 'var(--button-secondary-active-border)',
            secondaryHoverBorder: 'var(--button-secondary-hover-border)',
            tertiaryBg: 'var(--button-tertiary-bg)',
            tertiaryBorder: 'var(--button-tertiary-border)',
            tertiaryHoverBg: 'var(--button-tertiary-hover-bg)',
            tertiaryHoverBorder: 'var(--button-tertiary-hover-border)',
            tertiarydisabledBg: 'var(--button-tertiary-disabled-bg)',
            tertiaryDisabledBorder: 'var(--button-tertiary-disabled-border)',
            tertiaryActiveBg: 'var(--accent-color-highlight)',
        },
        Checkbox: {
            background: colors_v2_1.COLOR_V2.GRAY_20,
            border: colors_v2_1.COLOR_V2.GRAY_80,
            borderFocused: colors_v2_1.BASE_LIGHT_COLOR.BLUE,
            disableBgColor: colors_v2_1.COLOR_V2.GRAY_20,
            disableBorderColor: colors_v2_1.COLOR_V2.GRAY_60,
            disablecheckedBgColor: colors_v2_1.COLOR_V2.GRAY_20,
            invalidBorderColor: colors_v2_1.BASE_LIGHT_COLOR.RED,
        },
        IconButton: {
            activePrimaryBgColor: colors_v2_1.COLOR_V2.BLUE_LIGHT_50,
            focusBorderColor: colors_v2_1.COLOR_V2.BLUE_LIGHT_500,
            hoverPrimaryBgColor: colors_v2_1.COLOR_V2.GRAY_20,
            primaryActiveFillColor: colors_v2_1.COLOR_V2.BLUE,
            primaryBgColor: colors_v2_1.COLOR_V2.WHITE,
            primaryBorderColor: colors_v2_1.COLOR_V2.GRAY_40,
            primaryDisabledBgColor: colors_v2_1.COLOR_V2.GRAY_20,
            primaryDisabledBorderColor: colors_v2_1.COLOR_V2.GRAY_40,
            primaryHoverBorderColor: colors_v2_1.COLOR_V2.GRAY_50,
            secondaryActiveBorderColor: 'transparent',
        },
        IndicatorRangeInput: {
            thumb: 'var(--indicator-range-input-thumb)',
            trackBg: 'var(--indicator-range-input-track-bg)',
        },
        Input: {
            backgroundColor: colors_1.COLOR.WHITE,
            backgroundColorDisabled: colors_v2_1.COLOR_V2.GRAY_20,
            placeholderColor: colors_1.COLOR.GRAY_DARKEN_24,
            labelColor: colors_v2_1.COLOR_V2.GRAY_80,
            borderHover: 'var(--text-input-border-hover)',
        },
        Select: {
            disabledColor: colors_v2_1.COLOR_V2.GRAY_70,
            contrastTextColor: colors_1.COLOR.WHITE,
            borderColor: colors_v2_1.COLOR_V2.GRAY_40,
            focusedDescriptionColor: colors_v2_1.COLOR_V2.WHITE,
            optionHoverBg: 'var(--accent-color-highlight)',
            selectedActiveBg: 'var(--button-primary-hover)',
        },
        Tooltip: {
            backgroundColor: colors_1.COLOR.WHITE,
            color: colors_1.COLOR.TEXT,
        },
        general: {
            backgroundColor: colors_v2_1.COLOR_V2.GRAY_20,
            color: colors_1.COLOR.TEXT,
            primaryColor: colors_v2_1.COLOR_V2.BLUE,
            dangerColor: colors_v2_1.COLOR_V2.RED,
            contrastColor: 'var(--text-input-background)',
            focusColor: 'var(--accent-color-focus)',
        },
    },
    [THEME_ID.DARK]: {
        fontSizes: Sizes_1.fontSizes,
        Button: {
            primaryBg: 'var(--accent-color)',
            primaryHoverBg: 'var(--button-primary-hover)',
            primaryActiveBg: 'var(--button-primary-active)',
            primaryActiveBorder: 'var(--button-primary-active-border)',
            primaryFocusBorder: 'var(--button-primary-focus-border)',
            primaryDisabledBg: 'var(--button-primary-disabled-bg)',
            primaryDisabledText: 'var(--button-primary-disabled-text)',
            secondaryActiveBg: 'var(--button-secondary-active-bg)',
            secondaryActiveBorder: 'var(--button-secondary-active-border)',
            secondaryHoverBorder: 'var(--button-secondary-hover-border)',
            tertiaryBg: 'var(--button-tertiary-bg)',
            tertiaryBorder: 'var(--button-tertiary-border)',
            tertiaryHoverBg: 'var(--button-tertiary-hover-bg)',
            tertiaryHoverBorder: 'var(--button-tertiary-hover-border)',
            tertiarydisabledBg: 'var(--button-tertiary-disabled-bg)',
            tertiaryDisabledBorder: 'var(--button-tertiary-disabled-border)',
            tertiaryActiveBg: 'var(--accent-color-highlight)',
        },
        Checkbox: {
            background: colors_v2_1.COLOR_V2.GRAY_20,
            border: colors_v2_1.COLOR_V2.GRAY_60,
            borderFocused: colors_v2_1.BASE_DARK_COLOR.BLUE,
            disableBgColor: colors_v2_1.COLOR_V2.GRAY_10,
            disableBorderColor: colors_v2_1.COLOR_V2.GRAY_70,
            disablecheckedBgColor: colors_v2_1.COLOR_V2.GRAY_60,
            invalidBorderColor: colors_v2_1.BASE_DARK_COLOR.RED,
        },
        IconButton: {
            activePrimaryBgColor: colors_v2_1.COLOR_V2.BLUE_DARK_800,
            focusBorderColor: colors_v2_1.COLOR_V2.BLUE_DARK_600,
            hoverPrimaryBgColor: colors_v2_1.COLOR_V2.GRAY_80,
            primaryActiveFillColor: colors_1.COLOR.WHITE,
            primaryBgColor: colors_v2_1.COLOR_V2.GRAY_90,
            primaryBorderColor: colors_v2_1.COLOR_V2.GRAY_100,
            primaryDisabledBgColor: colors_v2_1.COLOR_V2.GRAY_95,
            primaryDisabledBorderColor: colors_v2_1.COLOR_V2.GRAY_90,
            primaryHoverBorderColor: colors_v2_1.COLOR_V2.GRAY_70,
            secondaryActiveBorderColor: colors_v2_1.COLOR_V2.BLUE_DARK_800,
        },
        IndicatorRangeInput: {
            thumb: 'var(--indicator-range-input-thumb)',
            trackBg: 'var(--indicator-range-input-track-bg)',
        },
        Input: {
            backgroundColor: colors_1.COLOR.BLACK_LIGHTEN_24,
            backgroundColorDisabled: colors_1.COLOR.GRAY_100,
            placeholderColor: colors_1.COLOR.GRAY_LIGHTEN_88,
            labelColor: colors_v2_1.COLOR_V2.GRAY_40,
            borderHover: 'var(--text-input-border-hover)',
        },
        Select: {
            disabledColor: colors_v2_1.COLOR_V2.GRAY_60,
            contrastTextColor: colors_1.COLOR.BLACK,
            borderColor: colors_v2_1.COLOR_V2.GRAY_90,
            focusedDescriptionColor: colors_v2_1.COLOR_V2.GRAY_40,
            optionHoverBg: 'var(--accent-color-highlight)',
            selectedActiveBg: 'var(--button-primary-active)',
        },
        Tooltip: {
            backgroundColor: colors_1.COLOR.TEXT,
            color: colors_1.COLOR.WHITE,
        },
        general: {
            backgroundColor: colors_1.COLOR.BLACK,
            color: colors_1.COLOR.WHITE,
            primaryColor: colors_v2_1.COLOR_V2.BLUE,
            dangerColor: colors_v2_1.COLOR_V2.RED,
            contrastColor: 'var(--text-input-background)',
            focusColor: 'var(--accent-color-focus)',
        },
    },
};
const ThemeProvider = (props) => (0, jsx_runtime_1.jsx)(react_1.ThemeProvider, Object.assign({}, props, { theme: props.theme }));
exports.ThemeProvider = ThemeProvider;
