"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropFileInput = exports.dropFileZonDescriptionStyle = exports.dropFileZoneHeadingStyle = exports.dropFileZoneLabelStyle = exports.dropFileZoneWrapperStyle = exports.dropFileWrapperStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2022 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const Icon_1 = require("../Icon");
const Identity_1 = require("../Identity");
const Layout_1 = require("../Layout");
const visuallyHiddenStyles = {
    clip: 'rect(0 0 0 0)',
    clipPath: 'inset(50%)',
    height: '1px',
    overflow: 'hidden',
    position: 'absolute',
    whiteSpace: 'nowrap',
    width: '1px',
};
exports.dropFileWrapperStyle = {
    maxWidth: '330px',
};
const dropFileZoneWrapperStyle = (theme, isDraggedOver) => ({
    width: '100%',
    padding: '28px 12px',
    border: `1px dashed ${theme.general.primaryColor}`,
    borderBottomWidth: '2px',
    borderRadius: '6px',
    textAlign: 'center',
    backgroundColor: isDraggedOver ? theme.general.backgroundColor : Identity_1.COLOR.WHITE,
    fontWeight: 400,
    fontSize: '0.75rem',
    lineHeight: '13px',
    color: Identity_1.COLOR.GRAY,
});
exports.dropFileZoneWrapperStyle = dropFileZoneWrapperStyle;
const dropFileZoneLabelStyle = theme => ({
    color: theme.general.primaryColor,
    cursor: 'pointer',
    ':focus-within': {
        outline: `1px solid ${theme.general.primaryColor}`,
    },
    ':hover': {
        textDecoration: 'underline',
    },
});
exports.dropFileZoneLabelStyle = dropFileZoneLabelStyle;
exports.dropFileZoneHeadingStyle = {
    display: 'block',
    whiteSpace: 'pre-line',
};
exports.dropFileZonDescriptionStyle = {
    marginTop: '12px',
    fontWeight: 400,
    fontSize: '0.625rem',
    lineHeight: '0.8125rem',
    color: Identity_1.COLOR.GRAY,
    whiteSpace: 'pre-line',
};
exports.DropFileInput = (0, react_1.forwardRef)((_a, ref) => {
    var { onFilesUploaded, onInvalidFilesDropError, dropFileZoneWrapperCSS, labelText, headingText, description, accept, multiple } = _a, inputProps = __rest(_a, ["onFilesUploaded", "onInvalidFilesDropError", "dropFileZoneWrapperCSS", "labelText", "headingText", "description", "accept", "multiple"]);
    const [isDraggedOver, setIsDraggedOver] = (0, react_1.useState)(false);
    const resetDraggedOver = () => setIsDraggedOver(false);
    const handleDragOver = (event) => {
        event.preventDefault();
        event.stopPropagation();
        event.dataTransfer.dropEffect = 'copy';
        if (event.dataTransfer.items.length > 0) {
            setIsDraggedOver(true);
        }
    };
    const handleDrop = (event) => {
        event.preventDefault();
        event.stopPropagation();
        resetDraggedOver();
        const { files } = event.dataTransfer;
        if (files.length < 1) {
            return;
        }
        const filesArr = multiple ? Array.from(files) : [files[0]];
        const areFilesValid = !!accept
            ? filesArr.every(file => accept
                .split(',')
                .map(v => v.trim())
                .includes(file.type))
            : true;
        if (!areFilesValid) {
            onInvalidFilesDropError();
            return;
        }
        onFilesUploaded(filesArr);
    };
    const handleChange = (event) => {
        const { files } = event.target;
        if (files.length < 1) {
            return;
        }
        onFilesUploaded(Array.from(files));
    };
    return ((0, jsx_runtime_1.jsxs)("div", Object.assign({ css: exports.dropFileWrapperStyle }, { children: [(0, jsx_runtime_1.jsx)("div", Object.assign({ css: (theme) => (Object.assign(Object.assign({}, (0, exports.dropFileZoneWrapperStyle)(theme, isDraggedOver)), dropFileZoneWrapperCSS)), "data-testid": "dropzone", onDragOver: handleDragOver, onDragLeave: resetDraggedOver, onDrop: handleDrop }, { children: (0, jsx_runtime_1.jsxs)(Layout_1.FlexBox, Object.assign({ align: "center", justify: "center", flexWrap: "wrap", css: { maxWidth: '280px', margin: '0 auto' } }, { children: [(0, jsx_runtime_1.jsx)(Icon_1.UploadIcon, { css: { margin: '12px 0' } }), (0, jsx_runtime_1.jsxs)("div", Object.assign({ css: { maxWidth: '160px', margin: '0 25px' } }, { children: [(0, jsx_runtime_1.jsx)("span", Object.assign({ css: exports.dropFileZoneHeadingStyle }, { children: headingText })), (0, jsx_runtime_1.jsxs)("label", Object.assign({ "aria-label": `${headingText} ${labelText} (${description})`, css: (theme) => (0, exports.dropFileZoneLabelStyle)(theme) }, { children: [(0, jsx_runtime_1.jsx)("span", { children: labelText }), (0, jsx_runtime_1.jsx)("input", Object.assign({ "data-testid": "file-input", ref: ref, accept: accept, multiple: multiple, css: visuallyHiddenStyles, onChange: handleChange, type: "file" }, inputProps))] }))] }))] })) })), description && (0, jsx_runtime_1.jsx)("p", Object.assign({ css: exports.dropFileZonDescriptionStyle }, { children: description }))] })));
});
exports.DropFileInput.displayName = 'DropFileInput';
