"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateProxyURL = void 0;
const path = __importStar(require("path"));
const url_1 = require("url");
const getLogger_1 = require("../logging/getLogger");
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
function generateProxyURL(authInfo, options) {
    let protocol = options.protocol;
    const { username, password } = options;
    if (!protocol) {
        logger.log('Defaulting to HTTP proxy');
        protocol = 'http';
    }
    const proxySettings = new url_1.URL(`${protocol}://${authInfo.host}`);
    if (authInfo.port) {
        proxySettings.port = authInfo.port.toString();
        logger.log(`Port set to "${authInfo.port}".`);
    }
    logger.log(`Proxy URL: (credentials hidden) ${proxySettings.toString()}`);
    if (username) {
        proxySettings.username = username;
        logger.log('Username set');
    }
    if (password) {
        proxySettings.password = password;
        logger.log('Password set');
    }
    return proxySettings;
}
exports.generateProxyURL = generateProxyURL;
//# sourceMappingURL=ProxyAuth.js.map