/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.probsoln;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.probsoln.DefProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.ForEachProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.LoadAllProblems;
import com.dickimawbooks.texparserlib.latex.probsoln.LoadExceptProblems;
import com.dickimawbooks.texparserlib.latex.probsoln.LoadRandomExcept;
import com.dickimawbooks.texparserlib.latex.probsoln.LoadRandomProblems;
import com.dickimawbooks.texparserlib.latex.probsoln.LoadSelectedProblems;
import com.dickimawbooks.texparserlib.latex.probsoln.NewProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.OnlyProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.OnlySolution;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnData;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnDatabase;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnException;
import com.dickimawbooks.texparserlib.latex.probsoln.Question;
import com.dickimawbooks.texparserlib.latex.probsoln.RandSeed;
import com.dickimawbooks.texparserlib.latex.probsoln.Solution;
import com.dickimawbooks.texparserlib.latex.probsoln.TextEnum;
import com.dickimawbooks.texparserlib.latex.probsoln.UseProblem;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ProbSolnSty
extends LaTeXSty {
    private ConcurrentHashMap<String, ProbSolnDatabase> databases;
    private ProbSolnDatabase tmpDatabase;
    private Vector<ProbSolnData> allEntries = null;
    private int dbInitialCapacity = 16;
    private Random random;

    public ProbSolnSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        this(16, false, keyValList, laTeXParserListener, bl);
    }

    public ProbSolnSty(int n, boolean bl, KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl2) throws IOException {
        super(keyValList, "probsoln", laTeXParserListener, bl2);
        this.dbInitialCapacity = n;
        this.databases = new ConcurrentHashMap();
        if (bl) {
            this.allEntries = new Vector(n);
        }
        ProbSolnDatabase probSolnDatabase = new ProbSolnDatabase(n, "default");
        this.databases.put("default", probSolnDatabase);
        this.random = new Random();
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new DefProblem(this));
        this.registerControlSequence(new OnlyProblem());
        this.registerControlSequence(new OnlySolution());
        this.registerControlSequence(new UseProblem(this));
        this.registerControlSequence(new NewProblem(this));
        this.registerControlSequence(new Question());
        this.registerControlSequence(new TextEnum());
        this.registerControlSequence(new ForEachProblem(this));
        this.registerControlSequence(new LoadAllProblems(this));
        this.registerControlSequence(new LoadSelectedProblems(this));
        this.registerControlSequence(new LoadExceptProblems(this));
        this.registerControlSequence(new LoadRandomProblems(this));
        this.registerControlSequence(new LoadRandomExcept(this));
        this.registerControlSequence(new RandSeed(this));
        this.registerControlSequence(new GenericCommand("prob@currentdb", null, this.getListener().createString("default")));
        if (this.getParser().getControlSequence("solution") == null) {
            this.registerControlSequence(new Solution());
        }
        this.registerControlSequence(new GenericCommand("solutionname", null, this.getListener().createString("Solution")));
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("let"));
        teXObjectList.add(new TeXCsRef("ifshowanswers"));
        teXObjectList.add(new TeXCsRef("iftrue"));
        this.registerControlSequence(new GenericCommand(true, "showanswers", null, teXObjectList));
        teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("let"));
        teXObjectList.add(new TeXCsRef("ifshowanswers"));
        teXObjectList.add(new TeXCsRef("iffalse"));
        this.registerControlSequence(new GenericCommand(true, "hideanswers", null, teXObjectList));
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        if (string.equals("answers")) {
            this.getListener().getControlSequence("showanswerstrue").process(this.getParser());
        } else if (string.equals("noanswers")) {
            this.getListener().getControlSequence("showanswersfalse").process(this.getParser());
        } else if (string.equals("usedefaultargs")) {
            this.getListener().getControlSequence("usedefaultprobargstrue").process(this.getParser());
        } else if (string.equals("usenodefaultargs")) {
            this.getListener().getControlSequence("usedefaultprobargsfalse").process(this.getParser());
        }
    }

    public boolean useDefaultArgs() {
        ControlSequence controlSequence = this.getListener().getControlSequence("ifusedefaultprobargs");
        return this.getListener().isIfTrue(controlSequence);
    }

    @Override
    protected void preOptions(TeXObjectList teXObjectList) throws IOException {
        NewIf.createConditional(true, this.getListener().getParser(), "ifshowanswers");
        NewIf.createConditional(true, this.getListener().getParser(), "ifusedefaultprobargs");
    }

    public ProbSolnDatabase getDatabase(String string) throws ProbSolnException {
        if (this.tmpDatabase != null && this.tmpDatabase.getName().equals(string)) {
            return this.tmpDatabase;
        }
        ProbSolnDatabase probSolnDatabase = this.databases.get(string);
        if (probSolnDatabase == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_db", string);
        }
        return probSolnDatabase;
    }

    public ProbSolnData getProblem(String string, String string2) throws ProbSolnException {
        ProbSolnData probSolnData = (ProbSolnData)this.getDatabase(string2).get(string);
        if (probSolnData == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_entry_in_db", string, string2);
        }
        return probSolnData;
    }

    public boolean isDatabaseDefined(String string) {
        return this.databases.containsKey(string);
    }

    public ProbSolnDatabase addDatabase(String string) throws ProbSolnException {
        if (this.databases.containsKey(string)) {
            throw new ProbSolnException(this.getParser(), "probsoln.db_exists", string);
        }
        ProbSolnDatabase probSolnDatabase = new ProbSolnDatabase(this.dbInitialCapacity, string);
        this.databases.put(string, probSolnDatabase);
        return probSolnDatabase;
    }

    public void moveProblem(String string, String string2, String string3) throws ProbSolnException {
        ProbSolnDatabase probSolnDatabase = this.databases.get(string2);
        if (probSolnDatabase == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_db", string2);
        }
        ProbSolnData probSolnData = (ProbSolnData)probSolnDatabase.remove(string);
        if (probSolnData == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_entry_in_db", string, string2);
        }
        probSolnDatabase = this.databases.get(string3);
        if (probSolnDatabase == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_db", string3);
        }
        probSolnData.setDataBaseLabel(string3);
        probSolnDatabase.put(string, probSolnData);
    }

    public Set<String> getDatabaseLabels() {
        return this.databases.keySet();
    }

    public int getDatabaseCount() {
        return this.databases.size();
    }

    public int getTotalProblemCount() {
        return this.allEntries == null ? 0 : this.allEntries.size();
    }

    public void addProblem(ProbSolnData probSolnData) throws IOException {
        String string = this.getCurrentDb();
        ProbSolnDatabase probSolnDatabase = this.tmpDatabase != null && this.tmpDatabase.getName().equals(string) ? this.tmpDatabase : this.databases.get(string);
        if (probSolnDatabase == null) {
            this.addDatabase(string);
        }
        probSolnData.setDataBaseLabel(string);
        probSolnDatabase.put(probSolnData.getName(), probSolnData);
        if (this.allEntries != null && !this.allEntries.contains(probSolnData)) {
            this.allEntries.add(probSolnData);
        }
    }

    public Iterator<ProbSolnData> allEntriesIterator() {
        return this.allEntries == null ? null : this.allEntries.iterator();
    }

    public String getCurrentDb() throws IOException {
        TeXParser teXParser;
        TeXObjectList teXObjectList;
        ControlSequence controlSequence = this.getListener().getControlSequence("prob@currentdb");
        if (controlSequence == null) {
            return "default";
        }
        if (controlSequence instanceof Expandable && (teXObjectList = ((Expandable)((Object)controlSequence)).expandfully(teXParser = this.getListener().getParser())) != null) {
            return teXObjectList.toString(teXParser);
        }
        return "default";
    }

    public ProbSolnDatabase getTmpDatabase() {
        if (this.tmpDatabase == null) {
            this.tmpDatabase = new ProbSolnDatabase(this.dbInitialCapacity, "PROBSOLN#TMP");
        }
        return this.tmpDatabase;
    }

    public void clearTmpDatabase() {
        if (this.tmpDatabase != null) {
            this.tmpDatabase.clear();
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandomSeed(long l) {
        this.random.setSeed(l);
    }
}

