/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.Label3D;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.UIManager;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class DimensionLine3D
extends Object3DBranch {
    private static final LineAttributes DIMENSION_LINE_ATTRIBUTES = new LineAttributes(LINE_WIDTH_SCALE_FACTOR * 1.5f, 0, true);
    private Transform3D dimensionLineRotations;
    private PropertyChangeListener cameraChangeListener;
    private PropertyChangeListener homeCameraListener;
    private CollectionListener<DimensionLine> dimensionLinesListener;

    public DimensionLine3D(DimensionLine dimensionLine, Home home, UserPreferences userPreferences, Object object, boolean bl) {
        super(dimensionLine, home, userPreferences, object);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(17);
        this.update();
    }

    @Override
    public void update() {
        final DimensionLine dimensionLine = (DimensionLine)this.getUserData();
        if (dimensionLine.isVisibleIn3D() && (dimensionLine.getLevel() == null || dimensionLine.getLevel().isViewableAndVisible())) {
            RenderingAttributes renderingAttributes;
            Appearance appearance;
            ColoringAttributes coloringAttributes;
            LineArray lineArray;
            Label label;
            Label label2;
            TransformGroup transformGroup;
            BranchGroup branchGroup;
            float f;
            float f2 = dimensionLine.getLength();
            String string = this.getUserPreferences().getLengthUnit().getFormat().format(Float.valueOf(f2));
            TextStyle textStyle = dimensionLine.getLengthStyle();
            if (textStyle == null) {
                textStyle = this.getUserPreferences().getDefaultTextStyle(dimensionLine.getClass());
            }
            Font font = textStyle.getFontName() != null ? new Font(textStyle.getFontName(), 0, 1) : UIManager.getFont("TextField.font");
            Font font2 = font.deriveFont(0, textStyle.getFontSize());
            LineMetrics lineMetrics = font2.getLineMetrics(string, new FontRenderContext(new AffineTransform(), true, true));
            float f3 = lineMetrics.getAscent();
            float f4 = dimensionLine.getOffset();
            float f5 = f = f4 <= 0.0f ? -lineMetrics.getDescent() - 1.0f : f3 + 1.0f;
            if (this.numChildren() == 0) {
                branchGroup = new BranchGroup();
                branchGroup.setCapability(12);
                branchGroup.setCapability(17);
                transformGroup = new TransformGroup();
                transformGroup.setCapability(18);
                transformGroup.setCapability(12);
                label2 = new TransformGroup();
                label2.setCapability(18);
                label2.setCapability(12);
                transformGroup.addChild((Node)label2);
                label = new Label(string, 0.0f, f);
                label.setColor(dimensionLine.getColor());
                label.setStyle(textStyle);
                label.setPitch(Float.valueOf(0.0f));
                Label3D label3D = new Label3D(label, null, false);
                label2.addChild((Node)label3D);
                lineArray = new LineArray(14, 1);
                lineArray.setCapability(1);
                coloringAttributes = new ColoringAttributes();
                coloringAttributes.setCapability(1);
                appearance = new Appearance();
                appearance.setColoringAttributes(coloringAttributes);
                appearance.setLineAttributes(DIMENSION_LINE_ATTRIBUTES);
                appearance.setCapability(8);
                Shape3D shape3D = new Shape3D((Geometry)lineArray, appearance);
                shape3D.setCapability(12);
                transformGroup.addChild((Node)shape3D);
                Shape3D shape3D2 = new Shape3D((Geometry)lineArray, this.getSelectionAppearance());
                shape3D2.setCapability(14);
                shape3D2.setPickable(false);
                renderingAttributes = shape3D2.getAppearance().getRenderingAttributes();
                transformGroup.addChild((Node)shape3D2);
                branchGroup.addChild((Node)transformGroup);
                this.addChild((Node)branchGroup);
            } else {
                transformGroup = (TransformGroup)((Group)((Group)this.getChild(0)).getChild(0));
                branchGroup = (Label3D)((Group)transformGroup.getChild(0)).getChild(0);
                label2 = (Label)branchGroup.getUserData();
                label2.setText(string);
                label2.setY(f);
                label2.setColor(dimensionLine.getColor());
                label2.setStyle(textStyle);
                branchGroup.update();
                label = (Shape3D)transformGroup.getChild(1);
                lineArray = (LineArray)label.getGeometry();
                coloringAttributes = label.getAppearance().getColoringAttributes();
                Shape3D shape3D = (Shape3D)transformGroup.getChild(2);
                renderingAttributes = shape3D.getAppearance().getRenderingAttributes();
            }
            float f6 = dimensionLine.getElevationStart();
            label2 = new Transform3D();
            label2.setTranslation(new Vector3f(dimensionLine.getXStart(), dimensionLine.getLevel() != null ? dimensionLine.getLevel().getElevation() + f6 : f6, dimensionLine.getYStart()));
            if (this.dimensionLineRotations == null) {
                this.dimensionLineRotations = new Transform3D();
            }
            double d = Math.atan2(dimensionLine.getElevationEnd() - f6, dimensionLine.getXEnd() - dimensionLine.getXStart());
            this.dimensionLineRotations.rotZ(d);
            appearance = new Transform3D();
            double d2 = Math.atan2(dimensionLine.getYStart() - dimensionLine.getYEnd(), dimensionLine.getXEnd() - dimensionLine.getXStart());
            appearance.rotY(d2);
            this.dimensionLineRotations.mul((Transform3D)appearance);
            appearance = new Transform3D();
            appearance.rotX((double)(-dimensionLine.getPitch()));
            this.dimensionLineRotations.mul((Transform3D)appearance);
            label2.mul(this.dimensionLineRotations);
            Transform3D transform3D = new Transform3D();
            transform3D.setTranslation(new Vector3f(0.0f, 0.0f, f4));
            label2.mul(transform3D);
            transformGroup.setTransform((Transform3D)label2);
            float f7 = dimensionLine.getEndMarkSize() / 2.0f;
            Point3f[] point3fArray = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(f2, 0.0f, 0.0f), new Point3f(-f7, 0.0f, f7), new Point3f(f7, 0.0f, -f7), new Point3f(0.0f, 0.0f, f7), new Point3f(0.0f, 0.0f, -f7), new Point3f(f2 - f7, 0.0f, f7), new Point3f(f2 + f7, 0.0f, -f7), new Point3f(f2, 0.0f, f7), new Point3f(f2, 0.0f, -f7), new Point3f(0.0f, 0.0f, -f4), new Point3f(0.0f, 0.0f, -f7), new Point3f(f2, 0.0f, -f4), new Point3f(f2, 0.0f, -f7)};
            lineArray.setCoordinates(0, point3fArray);
            coloringAttributes.setColor(new Color3f(dimensionLine.getColor() != null ? new Color(dimensionLine.getColor()) : Color.BLACK));
            final Home home = this.getHome();
            renderingAttributes.setVisible(this.getUserPreferences() != null && this.getUserPreferences().isEditingIn3DViewEnabled() && home.isItemSelected(dimensionLine));
            this.updateLengthLabelDirection(home.getCamera());
            if (this.cameraChangeListener == null) {
                this.cameraChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        DimensionLine dimensionLine = (DimensionLine)DimensionLine3D.this.getUserData();
                        if (DimensionLine3D.this.numChildren() > 0 && dimensionLine.isVisibleIn3D() && (dimensionLine.getLevel() == null || dimensionLine.getLevel().isViewableAndVisible())) {
                            String string = propertyChangeEvent.getPropertyName();
                            if (Camera.Property.X.name().equals(string) || Camera.Property.Y.name().equals(string) || Camera.Property.Z.name().equals(string)) {
                                DimensionLine3D.this.updateLengthLabelDirection((Camera)propertyChangeEvent.getSource());
                            }
                        }
                    }
                };
                this.homeCameraListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        ((Camera)propertyChangeEvent.getOldValue()).removePropertyChangeListener(DimensionLine3D.this.cameraChangeListener);
                        ((Camera)propertyChangeEvent.getNewValue()).addPropertyChangeListener(DimensionLine3D.this.cameraChangeListener);
                        DimensionLine3D.this.updateLengthLabelDirection(home.getCamera());
                    }
                };
                this.dimensionLinesListener = new CollectionListener<DimensionLine>(){

                    @Override
                    public void collectionChanged(CollectionEvent<DimensionLine> collectionEvent) {
                        if (collectionEvent.getType() == CollectionEvent.Type.DELETE && collectionEvent.getItem() == dimensionLine) {
                            home.getCamera().removePropertyChangeListener(DimensionLine3D.this.cameraChangeListener);
                            home.removePropertyChangeListener(Home.Property.CAMERA, DimensionLine3D.this.homeCameraListener);
                            home.removeDimensionLinesListener(this);
                        }
                    }
                };
                home.getCamera().addPropertyChangeListener(this.cameraChangeListener);
                home.addPropertyChangeListener(Home.Property.CAMERA, this.homeCameraListener);
                home.addDimensionLinesListener(this.dimensionLinesListener);
            }
        } else {
            this.removeAllChildren();
            this.dimensionLineRotations = null;
            if (this.cameraChangeListener != null) {
                this.getHome().getCamera().removePropertyChangeListener(this.cameraChangeListener);
                this.getHome().removePropertyChangeListener(Home.Property.CAMERA, this.homeCameraListener);
                this.getHome().removeDimensionLinesListener(this.dimensionLinesListener);
                this.cameraChangeListener = null;
                this.homeCameraListener = null;
                this.dimensionLinesListener = null;
            }
        }
    }

    private void updateLengthLabelDirection(Camera camera) {
        DimensionLine dimensionLine = (DimensionLine)this.getUserData();
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        this.dimensionLineRotations.transform(vector3f);
        Vector3f vector3f2 = new Vector3f((dimensionLine.getXEnd() + dimensionLine.getXStart()) / 2.0f - camera.getX(), (dimensionLine.getElevationEnd() + dimensionLine.getElevationStart()) / 2.0f - camera.getZ(), (dimensionLine.getYEnd() + dimensionLine.getYStart()) / 2.0f - camera.getY());
        TransformGroup transformGroup = (TransformGroup)((Group)((Group)this.getChild(0)).getChild(0)).getChild(0);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(dimensionLine.getLength() / 2.0f, 0.0f, 0.0f));
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotZ(vector3f.dot(vector3f2) > 0.0f ? Math.PI : 0.0);
        transform3D.mul(transform3D2);
        transformGroup.setTransform(transform3D);
    }
}

