"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListStackSetOperationResults = void 0;
const CloudFormationClient_1 = require("../CloudFormationClient");
const ListStackSetOperationResultsCommand_1 = require("../commands/ListStackSetOperationResultsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListStackSetOperationResultsCommand_1.ListStackSetOperationResultsCommand(input), ...args);
};
async function* paginateListStackSetOperationResults(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof CloudFormationClient_1.CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListStackSetOperationResults = paginateListStackSetOperationResults;
