/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;

public final class UtilityLogger {
    private final Logger logger;

    public UtilityLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "No logger provided");
    }

    public void logFatalStackTrace(Throwable t) {
        if (t == null || !this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.log(Level.SEVERE, t.getMessage(), t);
    }

    public void logSafeArguments(String[] args) {
        if (args == null || !this.logger.isLoggable(Level.INFO)) {
            return;
        }
        String passwordRedacted = "<password provided>";
        StringJoiner argsList = new StringJoiner(System.lineSeparator());
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg == null) continue;
            if (arg.matches("--password.*=.*")) {
                argsList.add("<password provided>");
                continue;
            }
            if (arg.startsWith("--password")) {
                argsList.add("<password provided>");
                if (!iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            argsList.add(arg);
        }
        this.logger.log(Level.INFO, String.format("Command line: %n%s", argsList.toString()));
    }

    public void logSQLWarnings(ResultSet resultSet) {
        if (resultSet == null || !this.logger.isLoggable(Level.INFO)) {
            return;
        }
        try {
            this.logSQLWarnings(resultSet.getWarnings());
            resultSet.clearWarnings();
        }
        catch (SQLException e) {
            this.logger.log(Level.WARNING, "Could not log SQL warnings for result set");
        }
    }

    public void logSQLWarnings(Statement statement) {
        if (statement == null || !this.logger.isLoggable(Level.INFO)) {
            return;
        }
        try {
            this.logSQLWarnings(statement.getWarnings());
            statement.clearWarnings();
        }
        catch (SQLException e) {
            this.logger.log(Level.WARNING, "Could not log SQL warnings for statement");
        }
    }

    public void logSystemClasspath() {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.log(Level.CONFIG, String.format("Classpath: %n%s", this.printPath(System.getProperty("java.class.path"))));
        this.logger.log(Level.CONFIG, String.format("LD_LIBRARY_PATH: %n%s", this.printPath(System.getenv("LD_LIBRARY_PATH"))));
    }

    public void logSystemProperties() {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        TreeMap<String, String> systemProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> propertyValue : System.getProperties().entrySet()) {
            String name = (String)propertyValue.getKey();
            if (!name.startsWith("java.") && !name.startsWith("os.") || name.endsWith(".path")) continue;
            systemProperties.put(name, (String)propertyValue.getValue());
        }
        this.logger.log(Level.CONFIG, String.format("System properties: %n%s", Utility.join(systemProperties, System.lineSeparator())));
    }

    private void logSQLWarnings(SQLWarning sqlWarning) {
        for (SQLWarning currentSqlWarning = sqlWarning; currentSqlWarning != null; currentSqlWarning = currentSqlWarning.getNextWarning()) {
            String message = String.format("%s%nError code: %d, SQL state: %s", currentSqlWarning.getMessage(), currentSqlWarning.getErrorCode(), currentSqlWarning.getSQLState());
            this.logger.log(Level.INFO, message, currentSqlWarning);
        }
    }

    private String printPath(String path) {
        if (path == null) {
            return "";
        }
        return String.join((CharSequence)System.lineSeparator(), path.split(File.pathSeparator));
    }
}

