/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    public static final String PROTOCOL = "jdbc:cassandra:";
    public static final String PROTOCOL_DBAAS = "jdbc:cassandra:dbaas:";
    public static final int DEFAULT_PORT = 9042;
    public static final String KEY_VERSION = "version";
    public static final String KEY_CONSISTENCY = "consistency";
    public static final String KEY_CONNECTION_RETRIES = "retries";
    public static final String KEY_LOAD_BALANCING_POLICY = "loadbalancing";
    public static final String KEY_LOCAL_DATACENTER = "localdatacenter";
    public static final String KEY_RETRY_POLICY = "retry";
    public static final String KEY_RECONNECT_POLICY = "reconnection";
    public static final String KEY_DEBUG = "debug";
    public static final String KEY_ENABLE_SSL = "enablessl";
    public static final String KEY_SSL_ENGINE_FACTORY = "sslenginefactory";
    public static final String KEY_CLOUD_SECURE_CONNECT_BUNDLE = "secureconnectbundle";
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_REQUEST_TIMEOUT = "requesttimeout";
    public static final String KEY_CONFIG_FILE = "configfile";
    public static final String KEY_COMPLIANCE_MODE = "compliancemode";
    public static final String TAG_USER = "user";
    public static final String TAG_PASSWORD = "password";
    public static final String TAG_DATABASE_NAME = "databaseName";
    public static final String TAG_SERVER_NAME = "serverName";
    public static final String TAG_PORT_NUMBER = "portNumber";
    public static final String TAG_ACTIVE_CQL_VERSION = "activeCqlVersion";
    public static final String TAG_CQL_VERSION = "cqlVersion";
    public static final String TAG_CONSISTENCY_LEVEL = "consistencyLevel";
    public static final String TAG_LOAD_BALANCING_POLICY = "loadBalancing";
    public static final String TAG_LOCAL_DATACENTER = "localDatacenter";
    public static final String TAG_RETRY_POLICY = "retry";
    public static final String TAG_RECONNECT_POLICY = "reconnection";
    public static final String TAG_DEBUG = "debug";
    public static final String TAG_CONNECTION_RETRIES = "retries";
    public static final String TAG_ENABLE_SSL = "enableSsl";
    public static final String TAG_SSL_ENGINE_FACTORY = "sslEngineFactory";
    public static final String TAG_CLOUD_SECURE_CONNECT_BUNDLE = "secureConnectBundle";
    public static final String TAG_CONFIG_FILE = "configFile";
    public static final String TAG_REQUEST_TIMEOUT = "requestTimeout";
    public static final String TAG_COMPLIANCE_MODE = "complianceMode";
    public static final String JSSE_TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String JSSE_TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String JSSE_KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    public static final String JSSE_KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    public static final String NULL_KEYWORD = "NULL";
    protected static final String WAS_CLOSED_CONN = "Method was called on a closed Connection.";
    protected static final String WAS_CLOSED_STMT = "Method was called on a closed Statement.";
    protected static final String WAS_CLOSED_RS = "Method was called on a closed ResultSet.";
    protected static final String NO_INTERFACE = "No object was found that matched the provided interface: %s";
    protected static final String NO_TRANSACTIONS = "The Cassandra implementation does not support transactions.";
    protected static final String ALWAYS_AUTOCOMMIT = "The Cassandra implementation is always in auto-commit mode.";
    protected static final String BAD_TIMEOUT = "The timeout value was less than zero.";
    protected static final String NOT_SUPPORTED = "The Cassandra implementation does not support this method.";
    protected static final String NO_GEN_KEYS = "The Cassandra implementation does not currently support returning generated keys.";
    protected static final String NO_MULTIPLE = "The Cassandra implementation does not currently support multiple open Result Sets.";
    protected static final String NO_RESULT_SET = "No ResultSet returned from the CQL statement passed in an 'executeQuery()' method.";
    protected static final String BAD_KEEP_RS = "The argument for keeping the current result set: %s is not a valid value.";
    protected static final String BAD_TYPE_RS = "The argument for result set type: %s is not a valid value.";
    protected static final String BAD_CONCURRENCY_RS = "The argument for result set concurrency: %s is not a valid value.";
    protected static final String BAD_HOLD_RS = "The argument for result set holdability: %s is not a valid value.";
    protected static final String BAD_FETCH_DIR = "Fetch direction value of: %s is illegal.";
    protected static final String BAD_AUTO_GEN = "Auto key generation value of: %s is illegal.";
    protected static final String BAD_FETCH_SIZE = "Fetch size of: %s rows may not be negative.";
    protected static final String MUST_BE_POSITIVE = "Index must be a positive number less or equal the count of returned columns: %d";
    protected static final String VALID_LABELS = "Name provided was not in the list of valid column labels: %s";
    protected static final String HOST_IN_URL = "Connection url must specify a host, e.g. jdbc:cassandra://localhost:9042/keyspace";
    protected static final String HOST_REQUIRED = "A 'host' name is required to build a Connection.";
    protected static final String BAD_KEYSPACE = "Keyspace names must be composed of alphanumerics and underscores (parsed: '%s').";
    protected static final String URI_IS_SIMPLE = "Connection url may only include host, port, and keyspace, consistency and version option, e.g. jdbc:cassandra://localhost:9042/keyspace?version=3.0.0&consistency=ONE";
    protected static final String SECURECONENCTBUNDLE_REQUIRED = "A 'secureconnectbundle' parameter is required.";
    protected static final String FORWARD_ONLY = "Can not position cursor with a type of TYPE_FORWARD_ONLY.";
    protected static final String MALFORMED_URL = "The string '%s' is not a valid URL.";
    protected static final String SSL_CONFIG_FAILED = "Unable to configure SSL: %s.";
    static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static Properties parseURL(String url) throws SQLException {
        Properties props = new Properties();
        if (url != null) {
            String keyspace;
            URI uri;
            props.setProperty(TAG_PORT_NUMBER, String.valueOf(9042));
            boolean isDbaasConnection = false;
            int uriStartIndex = PROTOCOL.length();
            if (url.startsWith(PROTOCOL_DBAAS)) {
                uriStartIndex = PROTOCOL_DBAAS.length();
                isDbaasConnection = true;
            }
            String rawUri = url.substring(uriStartIndex);
            try {
                uri = new URI(rawUri);
            }
            catch (URISyntaxException e) {
                throw new SQLSyntaxErrorException(e);
            }
            if (!isDbaasConnection) {
                String host = uri.getHost();
                if (host == null) {
                    throw new SQLNonTransientConnectionException(HOST_IN_URL);
                }
                props.setProperty(TAG_SERVER_NAME, host);
                int port = 9042;
                if (uri.getPort() >= 0) {
                    port = uri.getPort();
                }
                props.setProperty(TAG_PORT_NUMBER, String.valueOf(port));
            }
            if (StringUtils.isNotEmpty((CharSequence)(keyspace = uri.getPath()))) {
                if (keyspace.startsWith("/")) {
                    keyspace = keyspace.substring(1);
                }
                if (!keyspace.matches("[a-zA-Z]\\w+")) {
                    throw new SQLNonTransientConnectionException(String.format(BAD_KEYSPACE, keyspace));
                }
                props.setProperty(TAG_DATABASE_NAME, keyspace);
            }
            if (uri.getUserInfo() != null) {
                throw new SQLNonTransientConnectionException(URI_IS_SIMPLE);
            }
            String query = uri.getQuery();
            if (query != null && !query.isEmpty()) {
                Map<String, String> params = Utils.parseQueryPart(query);
                if (params.containsKey(KEY_VERSION)) {
                    props.setProperty(TAG_CQL_VERSION, params.get(KEY_VERSION));
                }
                if (params.containsKey("debug")) {
                    props.setProperty("debug", params.get("debug"));
                }
                if (params.containsKey(KEY_CONSISTENCY)) {
                    props.setProperty(TAG_CONSISTENCY_LEVEL, params.get(KEY_CONSISTENCY));
                }
                if (params.containsKey("retries")) {
                    props.setProperty("retries", params.get("retries"));
                }
                if (params.containsKey(KEY_LOAD_BALANCING_POLICY)) {
                    props.setProperty(TAG_LOAD_BALANCING_POLICY, params.get(KEY_LOAD_BALANCING_POLICY));
                }
                if (params.containsKey(KEY_LOCAL_DATACENTER)) {
                    props.setProperty(TAG_LOCAL_DATACENTER, params.get(KEY_LOCAL_DATACENTER));
                }
                if (params.containsKey("retry")) {
                    props.setProperty("retry", params.get("retry"));
                }
                if (params.containsKey("reconnection")) {
                    props.setProperty("reconnection", params.get("reconnection"));
                }
                if (params.containsKey(KEY_ENABLE_SSL)) {
                    props.setProperty(TAG_ENABLE_SSL, params.get(KEY_ENABLE_SSL));
                }
                if (params.containsKey(KEY_SSL_ENGINE_FACTORY)) {
                    props.setProperty(TAG_SSL_ENGINE_FACTORY, params.get(KEY_SSL_ENGINE_FACTORY));
                }
                if (params.containsKey(KEY_CLOUD_SECURE_CONNECT_BUNDLE)) {
                    props.setProperty(TAG_CLOUD_SECURE_CONNECT_BUNDLE, params.get(KEY_CLOUD_SECURE_CONNECT_BUNDLE));
                } else if (isDbaasConnection) {
                    throw new SQLNonTransientConnectionException(SECURECONENCTBUNDLE_REQUIRED);
                }
                if (params.containsKey("user")) {
                    props.setProperty("user", params.get("user"));
                }
                if (params.containsKey("password")) {
                    props.setProperty("password", params.get("password"));
                }
                if (params.containsKey(KEY_REQUEST_TIMEOUT)) {
                    props.setProperty(TAG_REQUEST_TIMEOUT, params.get(KEY_REQUEST_TIMEOUT));
                }
                if (params.containsKey(KEY_CONFIG_FILE)) {
                    props.setProperty(TAG_CONFIG_FILE, params.get(KEY_CONFIG_FILE));
                }
                if (params.containsKey(KEY_COMPLIANCE_MODE)) {
                    props.setProperty(TAG_COMPLIANCE_MODE, params.get(KEY_COMPLIANCE_MODE));
                }
            } else if (isDbaasConnection) {
                throw new SQLNonTransientConnectionException(SECURECONENCTBUNDLE_REQUIRED);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("URL: '{}' parsed to: {}", (Object)url, (Object)props);
        }
        return props;
    }

    public static String createSubName(Properties props) throws SQLException {
        URI uri;
        String host;
        String keyspace = props.getProperty(TAG_DATABASE_NAME);
        if (keyspace != null) {
            keyspace = StringUtils.prependIfMissing((String)keyspace, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        if ((host = props.getProperty(TAG_SERVER_NAME)) == null) {
            throw new SQLNonTransientConnectionException(HOST_REQUIRED);
        }
        int port = 9042;
        if (StringUtils.isNotBlank((CharSequence)props.getProperty(TAG_PORT_NUMBER))) {
            port = Integer.parseInt(props.getProperty(TAG_PORT_NUMBER));
        }
        try {
            uri = new URI(null, null, host, port, keyspace, Utils.makeQueryString(props), null);
        }
        catch (Exception e) {
            throw new SQLNonTransientConnectionException(e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sub-name: '{}' created from: {}", (Object)uri.toString(), (Object)props);
        }
        return uri.toString();
    }

    protected static String makeQueryString(Properties props) {
        StringBuilder sb = new StringBuilder();
        String version = props.getProperty(TAG_CQL_VERSION);
        String consistency = props.getProperty(TAG_CONSISTENCY_LEVEL);
        if (StringUtils.isNotBlank((CharSequence)consistency)) {
            sb.append(KEY_CONSISTENCY).append("=").append(consistency);
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(KEY_VERSION).append("=").append(version);
        }
        if (sb.length() > 0) {
            return sb.toString().trim();
        }
        return null;
    }

    protected static Map<String, String> parseQueryPart(String query) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : query.split("&")) {
            try {
                String[] pair = param.split("=");
                String key = URLDecoder.decode(pair[0], StandardCharsets.UTF_8.displayName()).toLowerCase();
                String value = "";
                if (pair.length > 1) {
                    value = URLDecoder.decode(pair[1], StandardCharsets.UTF_8.displayName());
                }
                params.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLSyntaxErrorException(e);
            }
        }
        return params;
    }

    public static Map<DriverOption, Object> parseReconnectionPolicy(String reconnectionPolicyString) {
        String policyRegex = "([a-zA-Z.]*Policy)(\\()(.*)(\\))";
        Pattern policyPattern = Pattern.compile("([a-zA-Z.]*Policy)(\\()(.*)(\\))");
        Matcher policyMatcher = policyPattern.matcher(reconnectionPolicyString);
        if (policyMatcher.matches() && policyMatcher.groupCount() > 0) {
            String primaryReconnectionPolicy = policyMatcher.group(1);
            String reconnectionPolicyParams = policyMatcher.group(3);
            return Utils.getReconnectionPolicy(primaryReconnectionPolicy, reconnectionPolicyParams);
        }
        return null;
    }

    private static Map<DriverOption, Object> getReconnectionPolicy(String primaryReconnectionPolicy, String parameters) {
        HashMap<DriverOption, Object> policyParametersMap = new HashMap<DriverOption, Object>();
        String primaryReconnectionPolicyClass = primaryReconnectionPolicy;
        if (!primaryReconnectionPolicy.contains(".")) {
            primaryReconnectionPolicyClass = "com.datastax.oss.driver.internal.core.connection." + primaryReconnectionPolicy;
        }
        policyParametersMap.put((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, primaryReconnectionPolicyClass);
        if (parameters.length() > 0) {
            String paramsRegex = "([^,]+\\(.+?\\))|([^,]+)";
            Pattern paramsPattern = Pattern.compile("([^,]+\\(.+?\\))|([^,]+)");
            Matcher paramsMatcher = paramsPattern.matcher(parameters);
            int argPos = 0;
            while (paramsMatcher.find()) {
                if (paramsMatcher.groupCount() <= 0 || !paramsMatcher.group().trim().startsWith("(")) continue;
                String param = paramsMatcher.group();
                if (param.toLowerCase().contains("(long)")) {
                    long delay = Long.parseLong(param.toLowerCase().replace("(long)", "").trim());
                    if (argPos == 0) {
                        policyParametersMap.put((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofSeconds(delay));
                    } else if (argPos == 1 && "com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy".equals(primaryReconnectionPolicyClass)) {
                        policyParametersMap.put((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, Duration.ofSeconds(delay));
                    }
                }
                ++argPos;
            }
        }
        return policyParametersMap;
    }
}

