/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.CassandraResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.MetadataResultSets;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;

public class CassandraDatabaseMetaData
implements DatabaseMetaData {
    static final int JDBC_MAJOR_VERSION = 4;
    static final int JDBC_MINOR_VERSION = 0;
    static final int UNKNOWN_MAX_VALUE = 0;
    static final int KEYSPACE_NAME_MAX_LENGTH = 48;
    static final int TABLE_NAME_MAX_LENGTH = 48;
    static final String CATALOG_VENDOR_TERM = "Cluster";
    static final String SCHEMA_VENDOR_TERM = "Keyspace";
    private final CassandraConnection connection;
    private final Metadata metadata;
    private CassandraStatement statement;

    public CassandraDatabaseMetaData(CassandraConnection connection) throws SQLException {
        this.connection = connection;
        this.statement = new CassandraStatement(this.connection);
        this.metadata = this.connection.getClusterMetadata();
    }

    @Override
    public boolean isWrapperFor(@NonNull Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(@NonNull Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLFeatureNotSupportedException(String.format("No object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return CATALOG_VENDOR_TERM;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.checkStatementClosed();
        return MetadataResultSets.INSTANCE.makeCatalogs(this.statement);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            this.statement.connection = this.connection;
            String schemaNamePattern = schemaPattern;
            if (schemaPattern == null) {
                schemaNamePattern = this.connection.getSchema();
            }
            return MetadataResultSets.INSTANCE.makeColumns(this.statement, schemaNamePattern, tableNamePattern, columnNamePattern);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public int getDatabaseMajorVersion() {
        return CassandraConnection.dbMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return CassandraConnection.dbMinorVersion;
    }

    @Override
    public String getDatabaseProductName() {
        return "Cassandra";
    }

    @Override
    public String getDatabaseProductVersion() {
        return String.format("%d.%d.%d", CassandraConnection.dbMajorVersion, CassandraConnection.dbMinorVersion, CassandraConnection.dbPatchVersion);
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 4;
    }

    @Override
    public int getDriverMinorVersion() {
        return 4;
    }

    @Override
    public String getDriverName() {
        return "Cassandra JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return String.format("%d.%d.%d", 4, 4, 0);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getIdentifierQuoteString() {
        return " ";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            String schemaName = schema;
            if (schema == null) {
                schemaName = this.connection.getSchema();
            }
            return MetadataResultSets.INSTANCE.makeIndexes(this.statement, schemaName, table, unique, approximate);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0x3FFFFFFF;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 127;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 65535;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 65535;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 48;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 48;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public String getNumericFunctions() {
        return "";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            String schemaName = schema;
            if (schema == null) {
                schemaName = this.connection.getSchema();
            }
            return MetadataResultSets.INSTANCE.makePrimaryKeys(this.statement, schemaName, table);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public String getProcedureTerm() {
        return "";
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() {
        return "";
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public String getSchemaTerm() {
        return SCHEMA_VENDOR_TERM;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.checkStatementClosed();
        return MetadataResultSets.INSTANCE.makeSchemas(this.statement, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.checkStatementClosed();
        if (catalog != null && !catalog.equals(this.statement.connection.getCatalog())) {
            throw new SQLSyntaxErrorException("Catalog name must exactly match or be null.");
        }
        return MetadataResultSets.INSTANCE.makeSchemas(this.statement, schemaPattern);
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getStringFunctions() {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.checkStatementClosed();
        return MetadataResultSets.INSTANCE.makeTableTypes(this.statement);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean askingForTable;
        boolean bl = askingForTable = types == null;
        if (types != null) {
            for (String typeName : types) {
                if (!"TABLE".equals(typeName)) continue;
                askingForTable = true;
                break;
            }
        }
        if ((catalog == null || catalog.equals(this.connection.getCatalog())) && askingForTable) {
            this.checkStatementClosed();
            return MetadataResultSets.INSTANCE.makeTables(this.statement, schemaPattern, tableNamePattern);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getTimeDateFunctions() {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getURL() {
        return this.connection.url;
    }

    @Override
    public String getUserName() {
        if (this.connection.username == null) {
            return "";
        }
        return this.connection.username;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.checkStatementClosed();
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return 1 == holdability;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return 1003 == type;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return 0 == level;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    private void checkStatementClosed() throws SQLException {
        if (this.statement.isClosed()) {
            this.statement = new CassandraStatement(this.connection);
        }
    }
}

